/*
 * Device file resource family
 *
 * Copyright (C) 2002, Olaf Kirch <okir@lst.de>
 */

#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include "resmgrd.h"

typedef struct res_file_name res_file_name_t;
struct res_file_name {
	res_name_t	base;
	char *		filename;
};

static res_name_t *	res_file_name_parse(const char *);
static const char *	res_file_name_print(res_name_t *);
static void		res_file_name_free(res_name_t *);
static int		res_file_match(res_name_t *, res_device_t *);
static int		res_file_open(res_name_t *, int);

res_family_t	res_family_file = {
	"file",
	0,			/* no special export flags required */
	res_file_name_parse,
	res_file_name_print,
	res_file_name_free,
	res_file_match,
	res_file_open,
};

res_name_t *
res_file_name_parse(const char *name)
{
	res_file_name_t	*fp;

	fp = (res_file_name_t *) calloc(1, sizeof(*fp) + strlen(name) + 1);
	fp->base.ops = &res_family_file;
	fp->filename = (char *) (fp + 1);
	strcpy(fp->filename, name);
	return (res_name_t *) fp;
}

const char *
res_file_name_print(res_name_t *np)
{
	res_file_name_t	*fp = (res_file_name_t *) np;

	return fp->filename;
}

void
res_file_name_free(res_name_t *np)
{
	memset(np, 0, sizeof(res_file_name_t));
	free(np);
}

int
res_file_match(res_name_t *np, res_device_t *dev)
{
	res_file_name_t	*fp = (res_file_name_t *) np;

	return !strcmp(fp->filename, dev->name);
}

int
res_file_open(res_name_t *np, int flags)
{
	res_file_name_t	*fp = (res_file_name_t *) np;

	flags = (flags & DEV_FLAGS_RO)? O_RDONLY : O_RDWR;
	return open(fp->filename, flags | O_NONBLOCK);
}
