#!/usr/bin/python
#
#  Copyright (c) 1998-2001 Sean Reifschneider, tummy.com, ltd.  
#	All Rights Reserved.
#
#  Output format generator "proxy" code.  Handles the generation of multiple
#  report formats automatically.  Is called by each of the "gen*.py" modules
#  to register their existance, and calls them as appropriate with report
#  data.
#
#  http://www.tummy.com/radiusContext/
#  ftp://ftp.tummy.com/pub/tummy/radiusContext/

global G_GeneratorList
G_GeneratorList = []


###########################################################################
#  create second-level directories based on the first "split" characters of
#  the login name.

def setSplit(split = 0):
	for gen in G_GeneratorList:
		if hasattr(gen, 'setSplit'):
			gen.setSplit(split)

def reportDir(dir, name = None):
	for gen in G_GeneratorList:
		if name == None or gen.genname == name:
			gen.reportDir(dir)

def reportIndex(index, name = None):
	for gen in G_GeneratorList:
		if name == None or gen.genname == name:
			gen.reportIndex(index)
	
def append(item):
	G_GeneratorList.append(item)

def getList():
	return(G_GeneratorList)

def Start(data):
	for gen in G_GeneratorList:
		gen.Start(data)

def Stop(data):
	for gen in G_GeneratorList:
		gen.Stop(data)

def Item(userData, sesData):
	for gen in G_GeneratorList:
		gen.Item(userData, sesData)

def IndexStart():
	for gen in G_GeneratorList:
		gen.IndexStart()

def IndexStop(indexData):
	for gen in G_GeneratorList:
		gen.IndexStop(indexData)

def IndexItem(indexData, userData):
	for gen in G_GeneratorList:
		gen.IndexItem(indexData, userData)
