<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:template match="/">
   <xsl:apply-templates />
</xsl:template>

<xsl:template match="pointless">
   <xsl:apply-templates />
</xsl:template>

<xsl:template match="pointless/title">
#
# <xsl:value-of select="."/>
#
</xsl:template>

<xsl:template match="background">
   <xsl:if test="@src != ''">
      =background_image_stretch("<xsl:value-of select="@src"/>")
   </xsl:if>
   <xsl:if test="@colour != ''">
      =background_color(<xsl:value-of select="@colour"/>)
   </xsl:if>
</xsl:template>

<xsl:template match="fonts">
=make_font_family("<xsl:value-of select="@family"/>", "<xsl:value-of select="normal/text()"/>", "<xsl:value-of select="bold/text()"/>", "<xsl:value-of select="italic/text()"/>", "<xsl:value-of select="monospace/text()"/>")
=font_family("<xsl:value-of select="@family"/>")
</xsl:template>

<xsl:template match="slide">
#---------------------#
# <xsl:value-of select="name"/>

=slide <xsl:value-of select="name"/>
=vskip(20)
<xsl:apply-templates />

</xsl:template>

<xsl:template match="name" />

<xsl:template match="par">
=begin-par 
<xsl:apply-templates />
=end-par
</xsl:template>

<xsl:template match="note">
=begin-comment
<xsl:value-of select="." />
=end-comment
</xsl:template>


<xsl:template match="slide/title">
=huge
=center <xsl:apply-templates />
=vskip(20)
=normal
</xsl:template>

<xsl:template match="centre">
=center <xsl:apply-templates />
</xsl:template>

<xsl:template match="em">{=it <xsl:apply-templates />}</xsl:template>
<xsl:template match="large">{=large <xsl:apply-templates />}</xsl:template>
<xsl:template match="small">{=small <xsl:apply-templates />}</xsl:template>

<xsl:template match="slide/list">
   <xsl:for-each select="li">
      <xsl:if test="@step='no'">
         =nostep
      </xsl:if>
      =vskip(8)
      =item <xsl:apply-templates />
   </xsl:for-each>
</xsl:template>

<xsl:template match="li/list">
   <xsl:for-each select="li">
      <xsl:if test="@step='no'">
         =nostep
      </xsl:if>
      =subitem <xsl:apply-templates />
   </xsl:for-each>
</xsl:template>

<xsl:template match="image">
<xsl:value-of select="@pos"/> =image("<xsl:value-of select="@src"/>")
</xsl:template>

<xsl:template match="step">=step</xsl:template>
<xsl:template match="br">=medskip</xsl:template>
<xsl:template match="uni">=unicode(<xsl:value-of select="@char" />)</xsl:template>

</xsl:stylesheet>
