/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#ifdef unicos
#include <sys/types.h>
#endif
#include "main.h"

const static short bitrates[2][4][16] = {
   { /* MPEG-2 */
      {0},
      /* Layer 3 */
      {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,0},
      /* Layer 2 */
      {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,0},
      /* Layer 1 */
      {0,32,48,56,64,80,96,112,128,144,160,176,192,224,256,0}
   },
   { /* MPEG-1 */
      {0},
      /* Layer 3 */
      {0,32,40,48,56,64,80,96,112,128,160,192,224,256,320,0},
      /* Layer 2 */
      {0,32,48,56,64,80,96,112,128,160,192,224,256,320,384,0},
      /* Layer 1 */
      {0,32,64,96,128,160,192,224,256,288,320,352,384,416,448}
   }
};

int determine_bit_rate( int max, unsigned char *buf)
{
   int ID=0, layer=0, bitrate=0, i=0;
   unsigned long rate=0;
   unsigned char *bp=NULL;

   for (i=0, bp=buf; i < max; i++, bp++) {
      if ((*bp & 0xFF) && (*(bp+1) & 0xF0)) {
         ID = (*(bp+1) >> 3) & 0x1;
         layer = (*(bp+1) >> 1) & 0x3;
         bitrate = (*(bp+2) >> 4) & 0xF;
         if ((rate = (unsigned long)bitrates[ID][layer][bitrate])) {
            (*statstr)->_BANDWIDTH_ = (rate * 1000 / 8);
            (*statstr)->first = 0;
            return 1;
         }
         if (slfp) {
            fprintf(slfp, "\n** Cannot determine bitrate.  File will be skipped.\n");
         }
         (*statstr)->file_skipped = 1;
      }
   }
   return 0;
}
