/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     rotate.c                                                       *
 *            rotate images at 90, 180 or 270 degrees clockwise              *
 * Author:    Andreas Tille                                                  *
 * Date:      30.09.1998                                                     *
 * Copyright: Andreas Tille, 1999, 2000; GNU Public License                  *
 *                                                                           *
 *****************************************************************************/

#include <math.h>
#include <stdlib.h>

#include "paul.h" 
#include <gtkimrot.h>

int MakeRotate(PAUL *p)
/* rotate images at 90, 180 or 270 degrees clockwise
 * --- Parameter: ---
 * PAUL   *p            : list of images
 * --- Return: ---
 * int     MakeMirror() : RET_ERR or RET_OK
 */
{
  PICTURE *bild;
  GList   *pl;
  char    *desc;
  long     flag = p->opt->f;
  GtkImRot *rot = g_new0(GtkImRot, 1);

  g_return_val_if_fail( IS_PAUL(p), RET_ERR );
  g_return_val_if_fail( BILD(p->piclist), RET_ERR );
  
  if ( Rotate90(flag) )       p->opt->angle =  90.0;
  else if ( Rotate180(flag) ) p->opt->angle = 180.0;
  else if ( Rotate270(flag) ) p->opt->angle = 270.0;

  for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
    rot->data   = bild->data;
    if ( bild->im ) {
      bild->im->rgb_data = NULL;  /* if not set to NULL it is freed in kill_image :-( */
      gdk_imlib_kill_image(bild->im);
      bild->im   = NULL;  /* make sure, that bild->im is created later             */
    }
    bild->DATA = NULL;  /* and mark the image databuffer empty because it points *
                         * to non-existent imlib rgb_data pointer                */
    rot->width  = bild->width;
    rot->height = bild->height;

    g_return_val_if_fail ( !gtk_imrot_rotate_image(rot, p->opt->angle), -1);
    NewImage(bild, rot->width, rot->height, rot->data);
    desc = g_strdup_printf("%s rotated %g degrees.", ImgFileName(bild), p->opt->angle);
    ImgChunksUpdate(bild, TypRotate, desc, APPROTATE, flag & (ROT_270|ROTVAR));
/*
rot->im wieder freigeben aber rgb-buffer erhalten
*/
  }

  p->opt->f &= ~(ROT_90 | ROT_180);
  return RET_OK;
}

