/*
**  POP3Folder.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_POP3Folder
#define _Pantomime_H_POP3Folder

#include <Pantomime/Folder.h>

#import <Foundation/NSDictionary.h>
#import <Foundation/NSString.h>

@class POP3CacheManager;

@interface POP3Folder : Folder
{
  NSMutableDictionary *sizeCache, *UIDCache;
  
  BOOL leaveOnServer;
  int retainPeriod;
  int count;
  long size;
}

- (void) deleteMessageAtIndex: (int) theIndex;

- (NSData *) prefetchMessageAtIndex: (int) theIndex;

- (NSData *) prefetchMessageAtIndex: (int) theIndex
                      numberOfLines: (unsigned int) theNumberOfLines;

- (BOOL) prefetch;

- (NSString *) UIDOfMessageAtIndex: (int) theIndex;
- (int) lengthOfMessageAtIndex: (int) theIndex;

- (BOOL) leaveOnServer;
- (void) setLeaveOnServer: (BOOL) aBOOL;

- (int) retainPeriod;
- (void) setRetainPeriod: (int) theRetainPeriod;

@end

//
// Private methods
//
@interface POP3Folder (Private)

- (void) _deleteOldMessagesWithMessageCount: (int) theCount;
- (void) _stat;

@end

#endif // _Pantomime_H_POP3Folder
