#!/usr/bin/perl
#
# See LICENSE for copyright information
#
# check_load.pl <host> [warn] [critical] [port]
#
# NetSaint host script to get the load and uptime from a client that is running
# netsaint_statd.
#

require 5.003;
BEGIN { $ENV{PATH} = '/bin' }
use Socket;
use POSIX;
use strict;

sub usage;

my $TIMEOUT = 15;

my %ERRORS = ('UNKNOWN', '-1',
		'OK', '0',
		'WARNING', '1',
		'CRITICAL', '2');
my $remote = shift || &usage(%ERRORS);
my $warn = shift || 5;
my $crit = shift || ($warn + 5);
my $port = shift || 1040;

my $remoteaddr = inet_aton("$remote");
my $paddr = sockaddr_in($port, $remoteaddr) || die "Can't create info for connection: #!\n";;
my $proto = getprotobyname('tcp');
socket(Server, PF_INET, SOCK_STREAM, $proto) || die "Can't create socket: $!";
setsockopt(Server, SOL_SOCKET, SO_REUSEADDR, 1);
connect(Server, $paddr) || die "Can't connect to server: $!";

my $state = "OK";
my $answer = undef;

# Just in case of problems, let's not hang NetSaint
$SIG{'ALRM'} = sub {
     close(Server);
     select(STDOUT);
     print "No Answer from Client\n";
     exit $ERRORS{"UNKNOWN"};
};
alarm($TIMEOUT);

select(Server);
$| = 1;
print Server "uptime\n";
my ($servanswer) = <Server>;
alarm(0);
close(Server);
select(STDOUT);

if ($servanswer =~ /^(.*) - (.*) /)
	{
	my $uptime = $1;
	my $load = $2;
	if ($load < $warn)
		{ 
		$answer = "Load ok - up $uptime, 5-min load $load\n";
		}
	elsif ($load < $crit)
		{
		$state = "WARNING";
		$answer = "5-min load currently $load, up $uptime\n";
		}
	else
		{
		$state = "CRITICAL";
		$answer = "5-min load currently $load, up $uptime\n";
		}
	}
else
	{
	$state = "UNKNOWN";
	$answer = "Information unknown!\n";
	}

print $answer;
exit $ERRORS{$state};

sub usage {
	print "Minimum arguments not supplied!\n";
	print "\n";
	print "Perl Check Load/Uptime plugin for NetSaint\n";
	print "Copyright (c) 1999 Charlie Cook\n";
	print "\n";
	print "Usage: $0 <host> [<warn [<crit> [<port>]]]\n";
	print "\n";
	print "<warn> = 5-min load average at which a warning message will be generated.\n	Defaults to 5.\n";
	print "<crit> = 5-min load average at which a critical message will be generated.\n	Defaults to warning level + 5.\n";
	print "<port> = Port that the status daemon is running on <host>.\n	Defaults to 1040.\n";
	exit $ERRORS{"UNKNOWN"};
}
