///////
   //    HtmlStatement.cc
   //    HtmlStatement Class definitions
   //
   //    Class for Html statements
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: HtmlStatement.cc,v 1.9 2003/12/30 09:38:47 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifdef HAVE_CONFIG_H
#include "htconfig.h"
#endif /* HAVE_CONFIG_H */

#include "HtmlStatement.h"

   // Static variables initialization
      int HtmlStatement::debug = 0;

///////
   //    Construction
///////

HtmlStatement::HtmlStatement()
: IDUrl(0),
   TagPosition(0),
   Tag(0),
   Statement(0),
   Row(1),
   LinkTagPosition(0)
{
}

///////
   //    Destruction
///////

HtmlStatement::~HtmlStatement ()
{
}

///////
   //    Reset the schedule content
///////

void HtmlStatement::Reset()
{
   IDUrl = 0;
   TagPosition = 0;
   Tag = 0;
   Statement = 0;
   Row = 1;
   LinkTagPosition = 0;
}


///////
   //    Output HtmlStatement object
///////

ostream& operator<<(ostream& output, const HtmlStatement& s)

{
   output << s.IDUrl << " / " << s.TagPosition;
   
   if (s.debug < 3) return output;
   
   // Only if debug level is greater than 2
   
   output << " (Tag : " << s.Tag << " Row: " << s.Row
      << " - Statement <"
      << s.Statement << ">)";
   
   return output;
}
