/* doscan - Denial Of Service Capable Auditing of Networks       -*- C++ -*-
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// event_queue implementation using the epoll interface.
// DO NOT INCLUDE THIS FILE, use event_queue::create() instead.

#ifndef EVENT_QUEUE_EPOLL_H
#define EVENT_QUEUE_EPOLL_H

#include "event_queue.h"

#include <vector>

class event_queue_epoll : public event_queue {
  unsigned count;
  int epoll_fd;

  // We have to keep track of "pending" file descriptors.  These
  // descriptors have been received from poll(), but we haven't
  // dispatched them yet.  Calls to unwatch() might reassign
  // descriptors.

  struct fd_activity {
    fd_handler* fdh;
    fd_handler::activity act;
  };

  typedef std::vector<fd_activity> fd_activities_t;
  fd_activities_t fd_activities;

  void forget_activity(fd_handler*);

  static unsigned convert_watch(fd_handler::watch_options);

protected:
  virtual void add_fd(event_queue::fd_handler*, fd_handler::watch_options);
  virtual void update_fd(event_queue::fd_handler*, fd_handler::watch_options);
  virtual void remove_fd(event_queue::fd_handler*);

public:
  event_queue_epoll(unsigned size_hint);
  virtual ~event_queue_epoll();

  virtual void run();
};

#endif // EVENT_QUEUE_EPOLL_H

// arch-tag: fb4a82e5-8f11-4164-b59d-2f0695a67c60
