<?php
/*
 * $Id: class.htmlWorkOrderBrowse.inc.php,v 1.1.2.1 2003/12/10 05:54:54 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('vw');
LoadStringResource('prj');
import('htmlView');

class htmlWorkOrderBrowse extends htmlView
{
	function htmlWorkOrderResults()
	{
		parent::htmlView();
		$this->sPagingMenuAction = 'htmlWorkOrderBrowse.Page';

		$this->sColumnTitle = STR_CMMN_OPTIONS;
	}
	
	function InitTemplate()
	{
		$this->Template = CreateTemplate(array('hForm' => 'htmlWorkOrderBrowse.tpl'));
		$this->_CreateBlocks();
		$this->_ResetBlocks();
	}

	function Render(&$oView)
	{
		global $dcl_info;

		if (!is_object($oView))
		{
			print('[htmlWorkOrderBrowse::Render] ' . STR_VW_VIEWOBJECTNOTPASSED);
			return;
		}

		$this->oView = &$oView;

		$this->InitTemplate();
		
		$this->_SetStaticOptions();
		if (!$this->_Execute())
			return;

		$this->_SetActionFormOptions();
		$this->_SetFilterStatusOptions();
		$this->_SetFilterTypeOptions();
		$this->_SetFilterPersonnelOptions();
		$this->_SetFilterProductOptions();
		
		$this->bShowPager = true;
		$this->_SetPager();

		$this->_SetVar('VAL_SEARCHACTION', menuLink());
		$this->_SetVar('VAL_VIEWSETTINGS', $this->oView->GetForm());

		if (!$this->oDB->next_record())
		{
			$this->_NoMatches();
			$this->_Finish();
			return;
		}

		$iOffset = 0;
		if (in_array('_num_accounts_', $this->oDB->Record))
			$iOffset = -1;

		do // next_record already called to check for matches
		{
			$this->_DisplayGroups();
			$this->_DisplayDetailHeader();
			$this->_DisplayDetail();
		}
		while ($this->oDB->next_record());

		$this->Template->parse('hSection', 'section', true);
		$this->Template->parse('hMatches', 'matches');
		$this->_Finish();
	}
	
	function Page()
	{
		global $dcl_info;

		commonHeader();
		
		$oView = CreateObject('dcl.boView');
		$oView->SetFromURL();

		if ((IsSet($GLOBALS['btnNav']) || IsSet($GLOBALS['jumptopage'])) && IsSet($GLOBALS['startrow']) && IsSet($GLOBALS['numrows']))
		{
			if (IsSet($GLOBALS['btnNav']) && $GLOBALS['btnNav'] == '<<')
				$oView->startrow = $GLOBALS['startrow'] - $GLOBALS['numrows'];
			else if (IsSet($GLOBALS['btnNav']) && $GLOBALS['btnNav'] == '>>')
				$oView->startrow = $GLOBALS['startrow'] + $GLOBALS['numrows'];
			else
			{
				$iPage = $GLOBALS['jumptopage'];
				if ($iPage < 1)
					$iPage = 1;

				$oView->startrow = ($iPage - 1) * $GLOBALS['numrows'];
			}

			if ($oView->startrow < 0)
				$oView->startrow = 0;

			$oView->numrows = $GLOBALS['numrows'];
		}
		else
		{
			$oView->numrows = 15;
			$oView->startrow = 0;
		}

		$filterStatus = '-1';
		$filterReportto = '0';
		$filterProduct = '0';
		$filterType = '0';
		if (IsSet($GLOBALS['filterStatus']))
			$filterStatus = $GLOBALS['filterStatus'];
		if (IsSet($GLOBALS['filterReportto']))
			$filterReportto = $GLOBALS['filterReportto'];
		if (IsSet($GLOBALS['filterProduct']))
			$filterProduct = $GLOBALS['filterProduct'];
		if (IsSet($GLOBALS['filterType']))
			$filterType = $GLOBALS['filterType'];

		$oView->RemoveDef('filternot', 'statuses.dcl_status_type');
		$oView->RemoveDef('filter', 'statuses.dcl_status_type');
		$oView->RemoveDef('filter', 'status');
		if ($filterStatus != '0')
		{
			if ($filterStatus == '-1')
				$oView->AddDef('filternot', 'statuses.dcl_status_type', '2');
			else if ($filterStatus == '-2')
				$oView->AddDef('filter', 'statuses.dcl_status_type', '2');
			else
				$oView->AddDef('filter', 'status', $filterStatus);
		}

		if ($filterReportto != '0')
			$oView->ReplaceDef('filter', 'responsible', $filterReportto);
		else
			$oView->RemoveDef('filter', 'responsible');

		if ($filterProduct != '0')
			$oView->ReplaceDef('filter', 'product', $filterProduct);
		else
			$oView->RemoveDef('filter', 'product');

		if ($filterType != '0')
			$oView->ReplaceDef('filter', 'type', $filterType);
		else
			$oView->RemoveDef('filter', 'type');
		
		$this->sColumnTitle = STR_CMMN_OPTIONS;
		$this->bShowPager = true;
		$this->Render($oView);
	}

	function _CreateBlocks()
	{
		$this->Template->set_block('hForm', 'pager', 'hPager');
		$this->Template->set_block('hForm', 'nomatches', 'hNomatches');
		$this->Template->set_block('hForm', 'matches', 'hMatches');

		$this->Template->set_block('matches', 'section', 'hSection');

		$this->Template->set_block('section', 'group', 'hGroup');
		$this->Template->set_block('section', 'detailHeader', 'hDetailHeader');
		$this->Template->set_block('section', 'detailRows', 'hDetailRows');

		$this->Template->set_block('detailHeader', 'detailHeaderCells', 'hDetailHeaderCells');

		$this->Template->set_block('detailHeaderCells', 'detailHeaderPadding', 'hDetailHeaderPadding');
		$this->Template->set_block('detailHeaderCells', 'detailHeaderColumnText', 'hDetailHeaderColumnText');
		$this->Template->set_block('detailHeaderCells', 'detailHeaderColumnLink', 'hDetailHeaderColumnLink');

		$this->Template->set_block('detailRows', 'detail', 'hDetail');
		$this->Template->set_block('detail', 'detailCells', 'hDetailCells');

		$this->Template->set_block('detailCells', 'detailPadding', 'hDetailPadding');
		$this->Template->set_block('detailCells', 'detailColumnText', 'hDetailColumnText');
		$this->Template->set_block('detailCells', 'detailColumnLink', 'hDetailColumnLink');

		$this->Template->set_block('hForm', 'actionFormOptions', 'hActionFormOptions');
		$this->Template->set_block('hForm', 'filterStatusOptions', 'hFilterStatusOptions');
		$this->Template->set_block('hForm', 'filterTypeOptions', 'hFilterTypeOptions');
		$this->Template->set_block('hForm', 'filterPersonnelOptions', 'hFilterPersonnelOptions');
		$this->Template->set_block('hForm', 'filterProductOptions', 'hFilterProductOptions');
		$this->Template->set_block('detailHeaderCells', 'detailHeaderCheckbox', 'hDetailHeaderCheckbox');
		$this->Template->set_block('detailCells', 'detailCheckbox', 'hDetailCheckbox');
		$this->Template->set_block('detailCells', 'detailColumnAccount', 'hDetailColumnAccount');
	}

	function _ResetBlocks()
	{
		$this->_SetVar('hPager', '');
		$this->_SetVar('hNomatches', '');
		$this->_SetVar('hMatches', '');
		$this->_SetVar('hSection', '');
		$this->_SetVar('hGroup', '');
		$this->_SetVar('hDetailHeader', '');
		$this->_SetVar('hDetailRows', '');
		$this->_SetVar('hDetailHeaderCells', '');
		$this->_SetVar('hDetailHeaderPadding', '');
		$this->_SetVar('hDetailHeaderColumnText', '');
		$this->_SetVar('hDetailHeaderColumnLink', '');
		$this->_SetVar('hDetail', '');
		$this->_SetVar('hDetailRows', '');
		$this->_SetVar('hDetailCells', '');
		$this->_SetVar('hDetailPadding', '');
		$this->_SetVar('hDetailColumnText', '');
		$this->_SetVar('hDetailColumnLink', '');
		$this->_SetVar('hActionFormOptions', '');
		$this->_SetVar('hFilterStatusOptions', '');
		$this->_SetVar('hFilterTypeOptions', '');
		$this->_SetVar('hFilterPersonnelOptions', '');
		$this->_SetVar('hFilterProductOptions', '');
		$this->_SetVar('hDetailHeaderCheckbox', '');
		$this->_SetVar('hDetailCheckbox', '');
		$this->_SetVar('hDetailColumnAccount', '');
	}

	function _SetStaticOptions()
	{
		parent::_SetStaticOptions();
		$this->_SetVar('TXT_STATUS', STR_WO_STATUS);
		$this->_SetVar('TXT_TYPE', STR_WO_TYPE);
		$this->_SetVar('TXT_GO', STR_CMMN_GO);
		$this->_SetVar('TXT_FILTER', 'Filter');
		$this->_SetVar('TXT_RESPONSIBLE', STR_WO_RESPONSIBLE);
		$this->_SetVar('TXT_PRODUCT', STR_WO_PRODUCT);
	}

	function _SetActionFormOptions()
	{
		global $g_oSec, $dcl_info;

		$aOptions = array(
			STR_VW_SAVESEARCH => array('menuAction' => 'boViews.add', 'hasPermission' => true),
			'Refine Search' => array('menuAction' => 'htmlWOSearches.ShowRequest', 'hasPermission' => true),
			STR_VW_EXPORTRESULTS => array('menuAction' => 'boViews.export', 'hasPermission' => true),
			'Batch Detail' => array('menuAction' => 'boWorkorders.batchdetail', 'hasPermission' => true),
			STR_VW_BATCHTIMECARD => array('menuAction' => 'boTimecards.batchadd', 'hasPermission' => $g_oSec->HasSecLvl($dcl_info['DCL_HAVE_WO'])),
			STR_PRJ_BATCHASSIGN => array('menuAction' => 'boWorkorders.batchassign', 'hasPermission' => $g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO'])),
			STR_PRJ_BATCHMOVE => array('menuAction' => 'htmlProjectmap.batchmove', 'hasPermission' => $g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
			);

		foreach ($aOptions as $sDisplay => $aOption)
		{
			if ($aOption['hasPermission'])
			{
				$this->_AddOption('hActionFormOptions', 'actionFormOptions', array(
    				'VAL_ACTIONOPTION' => $aOption['menuAction'],
					'TXT_ACTIONOPTION' => $sDisplay
					));
			}
		}
	}

	function _AddFilterStatusOption($sValue, $sDescription, $bSelected = false)
	{
		$this->_AddOption('hFilterStatusOptions', 'filterStatusOptions', array(
			'VAL_FILTERSTATUSOPTION' => $sValue,
			'VAL_FILTERSTATUSSELECTED' => ($bSelected ? ' selected' : ''),
			'TXT_FILTERSTATUSOPTION' => $sDescription
			));
	}

	function _SetFilterStatusOptions()
	{
		$filterStatus = IsSet($GLOBALS['filterStatus']) ? $GLOBALS['filterStatus'] : -1;

		$this->_AddFilterStatusOption('0', STR_CMMN_SELECTONE);

		$oStatus = CreateObject('dcl.dbStatuses');
		$oStatus->Connect();
		$oStatus->Query('SELECT id, name FROM statuses ORDER BY name');

		while ($oStatus->next_record())
		{
			$this->_AddFilterStatusOption($oStatus->f(0), $oStatus->f(1), $oStatus->f(0) == $filterStatus);
		}

		$oStatus->FreeResult();

		$this->_AddFilterStatusOption('-1', STR_CMMN_HIDECLOSEDTYPES, $filterStatus == '-1');
		$this->_AddFilterStatusOption('-2', STR_CMMN_ONLYCLOSEDTYPES, $filterStatus == '-2');
	}

	function _AddFilterTypeOption($sValue, $sDescription, $bSelected = false)
	{
		$this->_AddOption('hFilterTypeOptions', 'filterTypeOptions', array(
			'VAL_FILTERTYPEOPTION' => $sValue,
			'VAL_FILTERTYPESELECTED' => ($bSelected ? ' selected' : ''),
			'TXT_FILTERTYPEOPTION' => $sDescription
			));
	}

	function _SetFilterTypeOptions()
	{
		$filterType = IsSet($GLOBALS['filterType']) ? $GLOBALS['filterType'] : -1;

		$this->_AddFilterTypeOption('0', STR_CMMN_SELECTONE);

		$oType = CreateObject('dcl.dbWorkOrderType');
		$oType->Connect();
		$oType->Query('SELECT wo_type_id, type_name FROM dcl_wo_type ORDER BY type_name');

		while ($oType->next_record())
		{
			$this->_AddFilterTypeOption($oType->f(0), $oType->f(1), $oType->f(0) == $filterType);
		}

		$oType->FreeResult();
	}

	function _AddFilterPersonnelOption($sValue, $sDescription, $bSelected = false)
	{
		$this->_AddOption('hFilterPersonnelOptions', 'filterPersonnelOptions', array(
			'VAL_FILTERPERSONNELOPTION' => $sValue,
			'VAL_FILTERPERSONNELSELECTED' => ($bSelected ? ' selected' : ''),
			'TXT_FILTERPERSONNELOPTION' => $sDescription
			));
	}

	function _SetFilterPersonnelOptions()
	{
		$filterReportto = IsSet($GLOBALS['filterReportto']) ? $GLOBALS['filterReportto'] : -1;

		$this->_AddFilterPersonnelOption('0', STR_CMMN_SELECTONE);

		$oPersonnel = CreateObject('dcl.dbPersonnel');
		$oPersonnel->Connect();
		$oPersonnel->Query('SELECT id, short FROM personnel ORDER BY short');

		while ($oPersonnel->next_record())
		{
			$this->_AddFilterPersonnelOption($oPersonnel->f(0), $oPersonnel->f(1), $oPersonnel->f(0) == $filterReportto);
		}

		$oPersonnel->FreeResult();
	}

	function _AddFilterProductOption($sValue, $sDescription, $bSelected = false)
	{
		$this->_AddOption('hFilterProductOptions', 'filterProductOptions', array(
			'VAL_FILTERPRODUCTOPTION' => $sValue,
			'VAL_FILTERPRODUCTSELECTED' => ($bSelected ? ' selected' : ''),
			'TXT_FILTERPRODUCTOPTION' => $sDescription
			));
	}

	function _SetFilterProductOptions()
	{
		$filterProduct = IsSet($GLOBALS['filterProduct']) ? $GLOBALS['filterProduct'] : -1;

		$this->_AddFilterProductOption('0', STR_CMMN_SELECTONE);

		$oProduct = CreateObject('dcl.dbProducts');
		$oProduct->Connect();
		$oProduct->Query('SELECT id, name FROM products ORDER BY name');

		while ($oProduct->next_record())
		{
			$this->_AddFilterProductOption($oProduct->f(0), $oProduct->f(1), $oProduct->f(0) == $filterProduct);
		}

		$oProduct->FreeResult();
	}

	function _ResetDetailHeaderCells()
	{
		$this->_SetVar('hDetailHeaderPadding', '');
		$this->_SetVar('hDetailHeaderCheckbox', '');
		$this->_SetVar('hDetailHeaderColumnText', '');
		$this->_SetVar('hDetailHeaderColumnLink', '');
	}

	function _DisplayDetailHeader()
	{
		global $dcl_info;

		if (!$this->bNeedsHeader)
			return;

		$this->_SetVar('hDetailHeader', '');
		$this->_SetVar('hDetailHeaderCells', '');
		$this->_ResetDetailHeaderCells();

		if (count($this->oView->groups) > 0)
		{
			$this->_SetVar('VAL_DETAILHEADERPADDING', (count($this->oView->groups) + 1) * 20);
			$this->Template->parse('hDetailHeaderPadding', 'detailHeaderPadding');
			$this->Template->parse('hDetailHeaderCells', 'detailHeaderCells', true);

			// this avoids repeating cells
			$this->_ResetDetailHeaderCells();
		}

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
		{
			$this->Template->parse('hDetailHeaderCheckbox', 'detailHeaderCheckbox');
			$this->Template->parse('hDetailHeaderCells', 'detailHeaderCells', true);

			// this avoids repeating cells
			$this->_ResetDetailHeaderCells();
		}

		$iOffset = 0;

		for ($i = count($this->oView->groups); $i < (count($this->oView->groups) + count($this->oView->columns) + $iOffset); $i++)
		{
			if (count($this->oView->columnhdrs) > 0)
				$sHdr = $this->oView->columnhdrs[$i];
			else
				$sHdr = $this->oDB->GetFieldName($i);

			$this->_SetVar('VAL_COLUMNHEADER', $sHdr);

			if ($this->bColumnSort)
			{
				$this->oView->ClearDef('order');
				$this->oView->AddDef('order', $this->oView->columns[$i - count($this->oView->groups)], '');

				$this->_SetVar('LNK_COLUMNHEADER', menuLink('', 'menuAction=' . $this->sPagingMenuAction . '&' . $this->oView->GetURL()));
				$this->Template->parse('hDetailHeaderColumnLink', 'detailHeaderColumnLink');
			}
			else
			{
				$this->Template->parse('hDetailHeaderColumnText', 'detailHeaderColumnText');
			}

			$this->Template->parse('hDetailHeaderCells', 'detailHeaderCells', true);

			// this avoids repeating cells
			$this->_ResetDetailHeaderCells();
		}

		if ($this->sColumnTitle != '')
		{
			$this->_SetVar('VAL_COLUMNHEADER', $this->sColumnTitle);
			$this->Template->parse('hDetailHeaderColumnText', 'detailHeaderColumnText');
			$this->Template->parse('hDetailHeaderCells', 'detailHeaderCells', true);
		}

		$this->bNeedsHeader = false;
		$row = 0;

		$this->Template->parse('hDetailHeader', 'detailHeader');
	}

	function _ResetDetailCells()
	{
		$this->_SetVar('hDetailPadding', '');
		$this->_SetVar('hDetailCheckbox', '');
		$this->_SetVar('hDetailColumnText', '');
		$this->_SetVar('hDetailColumnLink', '');
		$this->_SetVar('hDetailColumnAccount', '');
	}

	function _DisplayDetail()
	{
		global $dcl_info;

		$this->_SetVar('hDetail', '');
		$this->_SetVar('hDetailCells', '');

		if ($this->oDB->cur % 2 == 0)
			$this->_SetVar('VAL_DETAILCLASS', 'even');
		else
			$this->_SetVar('VAL_DETAILCLASS', 'odd');

		if (count($this->oView->groups) > 0)
		{
			$this->_SetVar('VAL_DETAILPADDING', (count($this->oView->groups) + 1) * 20);
			$this->Template->parse('hDetailPadding', 'detailPadding');
			$this->Template->parse('hDetailCells', 'detailCells', true);

			// this avoids repeating cells
			$this->_ResetDetailCells();
		}

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
		{
			$this->_SetVar('VAL_ROWSELECT', sprintf('%d.%d', $this->oDB->f('jcn'), $this->oDB->f('seq')));
			$this->Template->parse('hDetailCheckbox', 'detailCheckbox');
			$this->Template->parse('hDetailCells', 'detailCells', true);

			// this avoids repeating cells
			$this->_ResetDetailCells();
		}

		$iAccountField = -1;
		if (in_array('accounts.name', $this->oView->columns))
		{
			foreach ($this->oView->columns as $iAccountField => $name)
			{
				if ($name == 'accounts.name')
					break;
			}
		}

		$iGroupCount = count($this->oView->groups);
		for ($i = $iGroupCount; $i < count($this->oView->columns) + count($this->oView->groups); $i++)
		{
			$sFieldName = $this->oDB->GetFieldName($i);
			$sFieldValue = $this->oDB->f($i);

			if ($sFieldName == 'jcn' || $sFieldName == 'seq')
			{
				$this->_SetVar('VAL_COLUMNVALUE', $this->oDB->f($i));
				$this->_SetVar('LNK_COLUMNVALUE', menuLink('', sprintf('menuAction=boWorkorders.viewjcn&jcn=%d&seq=%d',
							$this->oDB->f('jcn'),
							$this->oDB->f('seq'))));

				$this->Template->parse('hDetailColumnLink', 'detailColumnLink');
			}
			else if ($dcl_info['DCL_WO_SECONDARY_ACCOUNTS_ENABLED'] == 'Y' && $iAccountField == ($i - $iGroupCount))
			{
				$this->_SetVar('VAL_COLUMNVALUE', $this->oDB->f($i));
				$this->_SetVar('VAL_WOID', $this->oDB->f('jcn'));
				$this->_SetVar('VAL_SEQ', $this->oDB->f('seq'));
				if ($this->oDB->f('_num_accounts_') > 1)
				{
					$this->Template->parse('hDetailColumnAccount', 'detailColumnAccount');
				}
				else
				{
					$this->Template->parse('hDetailColumnText', 'detailColumnText');
				}
			}
			else
			{
				if ($this->oDB->IsTimestamp($i))
					$this->_SetVar('VAL_COLUMNVALUE', $this->oDB->FormatTimeStampForDisplay($this->oDB->f($i)));
				else if ($this->oDB->IsDate($i))
					$this->_SetVar('VAL_COLUMNVALUE', $this->oDB->FormatDateForDisplay($this->oDB->f($i)));
				else
					$this->_SetVar('VAL_COLUMNVALUE', $this->oDB->f($i));

				$this->Template->parse('hDetailColumnText', 'detailColumnText');
			}

			$this->Template->parse('hDetailCells', 'detailCells', true);

			// this avoids repeating cells
			$this->_ResetDetailCells();
		}

		$this->_DisplayOptions();

		$this->Template->parse('hDetail', 'detail');
		$this->Template->parse('hDetailRows', 'detailRows', true);
	}

	function _DisplayOptions()
	{
		$this->_SetVar('LNK_COLUMNDISABLED', '');
		$this->_SetVar('LNK_COLUMNVALUE', menuLink('', 'menuAction=boWorkorders.viewjcn&jcn=' . $this->oDB->f('jcn') . '&seq=' . $this->oDB->f('seq')));
		$this->_SetVar('VAL_COLUMNVALUE', STR_CMMN_VIEW);
		$this->Template->parse('hDetailColumnLink', 'detailColumnLink');

		$this->Template->parse('hDetailCells', 'detailCells', true);

		// this avoids repeating cells
		$this->_ResetDetailCells();
	}
}
?>
