<?php
/*
 * $Id: class.htmlTicketSearches.inc.php,v 1.3.4.7 2003/11/23 14:12:59 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wo');

class htmlTicketSearches
{
	function ShowView()
	{
		commonHeader();

		$oDB = CreateObject('dcl.dbViews');
		$oDB->Connect();
		if ($oDB->Load($GLOBALS['id']) != -1)
		{
			$oView = CreateObject('dcl.boView');
			$oView->SetFromURLString($oDB->viewurl);
			$this->Show($oView);
		}
	}

	function ShowRequest()
	{
		commonHeader();

		$oView = CreateObject('dcl.boView');
		$oView->SetFromURL();
		$this->Show($oView);
	}

	function Show($oView = '')
	{
		global $dcl_info;

		commonHeader();

		IncludeCalendar();
		$bView = is_object($oView);

		$objJS = CreateObject('dcl.jsAttributesets');
		$objJS->bModules = true;
		$objJS->bStatusTypes = true;
		$objJS->bDepartments = true;
		$objJS->DisplayAttributeScript();

		$objPersonnel = CreateObject('dcl.htmlPersonnel');
		$objProducts = CreateObject('dcl.htmlProducts');
		$objPriorities = CreateObject('dcl.htmlPriorities');
		$objSeverities = CreateObject('dcl.htmlSeverities');
		$objAccounts = CreateObject('dcl.htmlAccounts');
		$objStatuses = CreateObject('dcl.htmlStatuses');
		$objDepartment = CreateObject('dcl.htmlDepartments');
		$objModules = CreateObject('dcl.htmlProductModules');

		$oDBP = CreateObject('dcl.dbPersonnel');
		$oDBP->Load($GLOBALS['DCLID']);

		$Template = CreateTemplate(array('hForm' => 'htmlTicketSearch.tpl'));
		$Template->set_block('hForm', 'acols', 'hAcols');
		$Template->set_block('hForm', 'columnlist', 'hColumnlist');
		$Template->set_block('hForm', 'grouplist', 'hGrouplist');
		$Template->set_block('hForm', 'sortlist', 'hSortlist');

		$Template->set_var('hAcols', '');
		$Template->set_var('hColumnlist', '');
		$Template->set_var('hGrouplist', '');
		$Template->set_var('hSortlist', '');

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);

		$Template->set_var('TXT_TITLE', STR_TCK_SEARCHTITLE);
		$Template->set_var('TXT_RESPONSIBLE', STR_TCK_RESPONSIBLE);
		$Template->set_var('TXT_OPENEDBY', STR_TCK_OPENEDBY);
		$Template->set_var('TXT_CLOSEDBY', STR_TCK_CLOSEDBY);
		$Template->set_var('TXT_PRODUCT', STR_TCK_PRODUCT);
		$Template->set_var('TXT_PRIORITY', STR_TCK_PRIORITY);
		$Template->set_var('TXT_TYPE', STR_TCK_TYPE);
		$Template->set_var('TXT_ACCOUNT', STR_TCK_ACCOUNT);
		$Template->set_var('TXT_STATUS', STR_TCK_STATUS);
		$Template->set_var('TXT_OPENEDON', STR_TCK_OPENEDON);
		$Template->set_var('TXT_CLOSEDON', STR_TCK_CLOSEDON);
		$Template->set_var('TXT_STATUSON', STR_TCK_STATUSON);
		$Template->set_var('TXT_LASTACTION', STR_TCK_LASTACTIONON);
		$Template->set_var('TXT_FROM', STR_CMMN_FROM);
		$Template->set_var('TXT_TO', STR_CMMN_TO);
		$Template->set_var('TXT_ISSUESUMMARY', STR_TCK_ISSUE . '/' . STR_TCK_SUMMARY . '/' . STR_TCK_CONTACT);
		$Template->set_var('TXT_REPORTOPTIONS', STR_TCK_REPORTOPTIONS);
		$Template->set_var('TXT_REPORTTITLE', STR_CMMN_TITLE);
		$Template->set_var('TXT_STYLE', STR_CMMN_STYLE);
		$Template->set_var('TXT_AVAILABLECOLUMNS', STR_CMMN_AVAILCOLS);
		$Template->set_var('TXT_SHOWCOLUMNS', STR_CMMN_SHOWCOLS);
		$Template->set_var('TXT_GROUPING', STR_CMMN_GROUPING);
		$Template->set_var('TXT_SORTING', STR_CMMN_SORTING);
		$Template->set_var('TXT_PERSONNEL', 'Personnel*');
		$Template->set_var('TXT_SUMMARY', 'Summary*');
		$Template->set_var('TXT_MODULE', STR_CMMN_MODULE);
		$Template->set_var('TXT_STATUSTYPE', STR_CMMN_STATUSTYPE);
		$Template->set_var('TXT_DEPARTMENT', 'Department');

		$Template->set_var('BTN_SEARCH', STR_CMMN_SEARCH);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('BTN_COL', STR_CMMN_COL);
		$Template->set_var('BTN_GRP', STR_CMMN_GRP);
		$Template->set_var('BTN_ORD', STR_CMMN_SRT);
		$Template->set_var('BTN_RM', STR_CMMN_RM);
		$Template->set_var('BTN_UP', STR_CMMN_UP);
		$Template->set_var('BTN_DN', STR_CMMN_DN);

		if ($bView)
			$Template->set_var('VAL_REPORTTITLE', $oView->title);
		else
			$Template->set_var('VAL_REPORTTITLE', '');

		$Template->set_var('VAL_DEPARTMENT', $oDBP->department);
		$Template->set_var('VAL_ID', $GLOBALS['DCLID']);

		$aDefault['product'] = array();
		$aDefault['module'] = array();
		$aDefault['priority'] = array();
		$aDefault['type'] = array();
		$aDefault['account'] = array();
		$aDefault['status'] = array();
		$aDefault['statuses.dcl_status_type'] = array();
		$aDefault['department'] = array();
		$aDefault['personnel'] = array();
		$sPersonnelKey = '';
		$sStatusKey = '';
		$sModuleKey = '';

		if ($bView)
		{
			reset($oView->filter);
			while (list($field, $values) = each($oView->filter))
			{
				if (substr($field, 1) == '.department')
				{
					if ($field[0] == 'a')
						$Template->set_var('CHK_RESPONSIBLE', ' checked');
					else if ($field[0] == 'b')
						$Template->set_var('CHK_CREATEDBY', ' checked');
					else if ($field[0] == 'c')
						$Template->set_var('CHK_CLOSEDBY', ' checked');

					$field = 'department';
					$sPersonnelKey = '';
				}
				else if ($field == 'responsible' || $field == 'createdby' || $field == 'closedby')
				{
					$Template->set_var('CHK_' . strtoupper($field), ' checked');
					$field = 'personnel';
					$sPersonnelKey = '';
				}

				if (array_key_exists($field, $aDefault))
					$aDefault[$field] = $values;
			}

			if (is_array($aDefault['personnel']) && count($aDefault['personnel']) > 0)
			{
				$sPersonnel = implode(',', $aDefault['personnel']);
				$oDBP->Query("select department, id from personnel where id in ($sPersonnel)");
				while ($oDBP->next_record())
				{
					if (!in_array($oDBP->f(0), $aDefault['department']))
						$aDefault['department'][] = $oDBP->f(0);

					if ($sPersonnelKey != '')
						$sPersonnelKey .= ':';

					$sPersonnelKey .= sprintf('%d,%d', $oDBP->f(0), $oDBP->f(1));
				}
			}

			if (is_array($aDefault['status']) && count($aDefault['status']) > 0)
			{
				$sStatus = implode(',', $aDefault['status']);
				$oDBP->Query("select dcl_status_type, id from statuses where id in ($sStatus)");
				while ($oDBP->next_record())
				{
					if (!in_array($oDBP->f(0), $aDefault['statuses.dcl_status_type']))
						$aDefault['statuses.dcl_status_type'][] = $oDBP->f(0);

					if ($sStatusKey != '')
						$sStatusKey .= ':';

					$sStatusKey .= sprintf('%d,%d', $oDBP->f(0), $oDBP->f(1));
				}
			}

			if (is_array($aDefault['module']) && count($aDefault['module']) > 0)
			{
				$sModule = implode(',', $aDefault['module']);
				$oDBP->Query("select product_id, product_module_id from module where product_module_id in ($sModule)");
				while ($oDBP->next_record())
				{
					if (!in_array($oDBP->f(0), $aDefault['product']))
						$aDefault['product'][] = $oDBP->f(0);

					if ($sModuleKey != '')
						$sModuleKey .= ':';

					$sModuleKey .= sprintf('%d,%d', $oDBP->f(0), $oDBP->f(1));
				}
			}
		}
		else
		{
			$aDefault['product'] = 0;
			$aDefault['priority'] = 0;
			$aDefault['type'] = 0;
			$aDefault['account'] = 0;
			$aDefault['status'] = 0;
			$aDefault['project'] = 0;
			$aDefault['statuses.dcl_status_type'] = 1;
			$aDefault['department'] = array($oDBP->department);
			$aDefault['personnel'] = $GLOBALS['DCLID'];
			$sPersonnelKey = sprintf('%d,%d', $oDBP->department, $GLOBALS['DCLID']);
			$sStatusKey = '';
			$sModuleKey = '';

			if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
			{
				$Template->set_var('CHK_RESPONSIBLE', ' checked');
				$Template->set_var('CHK_CREATEBY', '');
				$Template->set_var('CHK_CLOSEDBY', '');
			}
			else
			{
				$Template->set_var('CHK_CREATEBY', ' checked');
				$Template->set_var('CHK_RESPONSIBLE', '');
				$Template->set_var('CHK_CLOSEDBY', '');
			}
		}

		$Template->set_var('VAL_SELECTPERSONNELKEY', $sPersonnelKey);
		$Template->set_var('VAL_SELECTSTATUSKEY', $sStatusKey);
		$Template->set_var('VAL_SELECTMODULEKEY', $sModuleKey);
		$Template->set_var('CMB_PERSONNEL', $objPersonnel->GetCombo($aDefault['personnel'], 'personnel', 'lastfirst', 8, false));
		$Template->set_var('CMB_DEPARTMENTS', $objDepartment->GetCombo($aDefault['department'], 'department', 'name', 8, false));
		$Template->set_var('CMB_PRODUCT', $objProducts->GetCombo($aDefault['product'], 'product', 'name', 0, 8, false));
		$Template->set_var('CMB_PRIORITIES', $objPriorities->GetCombo($aDefault['priority'], 'priority', 'name', 8, false));
		$Template->set_var('CMB_TYPE', $objSeverities->GetCombo($aDefault['type'], 'type', 'name', 8, false));
		$Template->set_var('CMB_ACCOUNTS', $objAccounts->GetCombo($aDefault['account'], 'account', 'name', 8, false));
		$Template->set_var('CMB_STATUS', $objStatuses->GetCombo($aDefault['status'], 'status', 'name', 8));

		// Modules only show for selected products
		$obj = CreateObject('dcl.htmlSelect');
		$obj->sName = 'module_id';
		$obj->iSize = 8;
		$Template->set_var('CMB_MODULES', $obj->GetHTML());

		// Empty status is for selecting status type, then filtering status if desired
		$obj->sName = 'status';
		$obj->iSize = 8;
		$Template->set_var('CMB_STATUSESEMPTY', $obj->GetHTML());

		// Status Types
		$obj->sName = 'dcl_status_type';
		$obj->iSize = 8;
		$obj->vDefault = $aDefault['statuses.dcl_status_type'];
		$obj->SetOptionsFromDb('dcl_status_type', 'dcl_status_type_id', 'dcl_status_type_name', '', 'dcl_status_type_id');
		$Template->set_var('CMB_STATUSTYPES', $obj->GetHTML());
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
		{
			$Template->set_var('CHK_SECLVLWO', ' CHECKED');
			$Template->set_var('CHK_NOSECLVLWO', '');
		}
		else
		{
			$Template->set_var('CHK_SECLVLWO', '');
			$Template->set_var('CHK_NOSECLVLWO', ' CHECKED');
		}

		$Template->set_var('VAL_SEARCHTEXT', '');
		if ($bView && count($oView->filterlike) > 0)
		{
			$searchText = '';
			reset($oView->filterlike);
			while (list($field, $values) = each($oView->filterlike))
				$searchText = $values[0];

			$Template->set_var('VAL_SEARCHTEXT', $searchText);
		}

		$aDateChecks = array('createdon', 'closedon', 'statuson', 'lastactionon');

		for ($i = 0; $i < count($aDateChecks); $i++)
			$Template->set_var('CHK_' . strtoupper($aDateChecks[$i]), '');

		if ($bView)
		{
			$Template->set_var('VAL_DATEFROM', '');
			$Template->set_var('VAL_DATETO', '');
			if (count($oView->filterdate) > 0)
			{
				$fromDate = '';
				$toDate = '';
				reset($oView->filterdate);
				while (list($field, $values) = each($oView->filterdate))
				{
					$Template->set_var('CHK_' . strtoupper($field), ' CHECKED');
					$fromDate = $values[0];
					$toDate = $values[1];
				}

				$Template->set_var('VAL_DATEFROM', $fromDate);
				$Template->set_var('VAL_DATETO', $toDate);
			}
		}
		else
		{
			$aFewDaysAgo = mktime(0, 0, 0, date('m'), date('d') - 3, date('Y'));
			$Template->set_var('VAL_DATEFROM', date($dcl_info['DCL_DATE_FORMAT'], $aFewDaysAgo));
			$Template->set_var('VAL_DATETO', date($dcl_info['DCL_DATE_FORMAT']));
		}

		$aCols = array(
				'ticketid' => STR_TCK_TICKET . '#',
				'responsible.short' => STR_TCK_RESPONSIBLE,
				'products.name' => STR_TCK_PRODUCT,
				'accounts.name' => STR_TCK_ACCOUNT,
				'statuses.name' => STR_TCK_STATUS,
				'summary' => STR_TCK_SUMMARY,
				'dcl_product_module.module_name' => STR_CMMN_MODULE,
				'version' => STR_TCK_VERSION,
				'createdby.short' => STR_TCK_OPENEDBY,
				'createdon' => STR_TCK_OPENEDON,
				'closedby.short' => STR_TCK_CLOSEDBY,
				'closedon' => STR_TCK_CLOSEDON,
				'statuson' => STR_TCK_STATUSON,
				'lastactionon' => STR_TCK_LASTACTIONON,
				'priorities.name' => STR_TCK_PRIORITY,
				'severities.name' => STR_TCK_TYPE,
				'contact' => STR_TCK_CONTACT,
				'contactphone' => STR_TCK_CONTACTPHONE,
				'contactemail' => STR_TCK_CONTACTEMAIL,
				'issue' => STR_TCK_ISSUE,
				'seconds' => STR_TCK_APPROXTIME,
				'dcl_status_type.dcl_status_type_name' => STR_CMMN_STATUSTYPE
			);

		if ($bView)
		{
			$aShow = array();
			$aGroup = array();

			reset($oView->columns);
			while (list(, $colName) = each($oView->columns))
			{
				if ($colName == 'a.short')
					$colName = 'responsible.short';
				else if ($colName == 'b.short')
					$colName = 'closedby.short';
				else if ($colName == 'c.short')
					$colName = 'createdby.short';

				$aShow[$colName] = $aCols[$colName];
			}

			reset($oView->groups);
			while (list(, $colName) = each($oView->groups))
			{
				if ($colName == 'a.short')
					$colName = 'responsible.short';
				else if ($colName == 'b.short')
					$colName = 'closedby.short';
				else if ($colName == 'c.short')
					$colName = 'createdby.short';

				$aGroup[$colName] = $aCols[$colName];
			}
		}
		else
		{
			$aShow = array(
					'ticketid' => STR_TCK_TICKET . '#',
					'responsible.short' => STR_TCK_RESPONSIBLE,
					'products.name' => STR_TCK_PRODUCT,
					'accounts.name' => STR_TCK_ACCOUNT,
					'statuses.name' => STR_TCK_STATUS,
					'summary' => STR_TCK_SUMMARY
				);

			$aGroup = array();
		}

		array_remove_keys($aCols, $aShow);
		array_remove_keys($aCols, $aGroup);

		reset($aCols);
		while (list($val, $text) = each($aCols))
		{
			$Template->set_var('VAL_ACOLSVALUE', htmlspecialchars($val));
			$Template->set_var('VAL_ACOLSTEXT', htmlspecialchars($text));
			$Template->parse('hAcols', 'acols', true);
		}

		reset($aShow);
		while (list($val, $text) = each($aShow))
		{
			$Template->set_var('VAL_COLSVALUE', htmlspecialchars($val));
			$Template->set_var('VAL_COLSTEXT', htmlspecialchars($text));
			$Template->parse('hColumnlist', 'columnlist', true);
		}

		reset($aGroup);
		while (list($val, $text) = each($aGroup))
		{
			$Template->set_var('VAL_GRPVALUE', htmlspecialchars($val));
			$Template->set_var('VAL_GRPTEXT', htmlspecialchars($text));
			$Template->parse('hGrouplist', 'grouplist', true);
		}

		if ($bView)
		{
			reset($oView->order);
			while (list(, $val) = each($oView->order))
			{
				$Template->set_var('VAL_SRTVALUE', htmlspecialchars($val));

				if ($val == 'priorities.weight')
					$sText = $aShow['priorities.name'];
				else if ($val == 'severities.weight')
					$sText = $aShow['severities.name'];
				else
					$sText = $aShow[$val];

				$Template->set_var('VAL_SRTTEXT', htmlspecialchars($sText));
				$Template->parse('hSortlist', 'sortlist', true);
			}
		}

		$Template->pparse('out', 'hForm');
	}

	function my()
	{
		$t = CreateTemplate(array('hForm' => 'htmlMyTicketSearches.tpl'));

		$t->set_var('TXT_TITLE', STR_TCK_SEARCHTITLE);
		$t->set_var('FORM_ACTION', menuLink());
		$t->set_var('TXT_TICKET', STR_TCK_TICKET);
		$t->set_var('TXT_FIND', STR_CMMN_FIND);
		$t->set_var('TXT_VIEW', STR_CMMN_VIEW);
		$t->set_var('COLOR_DARK', $GLOBALS['dcl_info']['DCL_COLOR_DARK']);
		$t->set_var('COLOR_LIGHT',$GLOBALS['dcl_info']['DCL_COLOR_LIGHT']);

		$obj = CreateObject('dcl.htmlViews');
		$t->set_var('CMB_VIEWS', $obj->GetCombo(0, 'viewid', 0, true, 'tickets'));

		$t->pparse('out', 'hForm');
	}
}
?>
