<?php
/*
 * $Id: class.htmlSession.inc.php,v 1.1.2.3 2003/12/14 01:11:29 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('stat');

class htmlSession
{
	function Kill()
	{
		commonHeader();

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$o = CreateObject('dcl.boSession');
		$o->Kill($GLOBALS);

		$this->Show();
	}

	function Show()
	{
		global $dcl_info;

		commonHeader();

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$oView = CreateObject('dcl.boView');
		$oView->table = 'dcl_session';
		$oView->style = 'report';
		$oView->title = 'DCL Sessions';
		$oView->AddDef('columns', '', array('personnel.short', 'create_date', 'update_date', 'dcl_session_id'));
		$oView->AddDef('order', '', array('personnel.short', 'create_date'));

		$oView->AddDef('columnhdrs', '', array(
				'User',
				'Login Date',
				'Last Access',
				'Session ID'));

		$oHtml = CreateObject('dcl.htmlSessionBrowse');
		$oHtml->Render($oView);
	}

	function Detail()
	{
		global $g_oSession, $g_oSec, $dcl_info;
		commonHeader();
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_ADD_USER']))
			return PrintPermissionDenied();

		echo '<pre>';
		print_r($g_oSession->session_data);
		echo '</pre>';
	}
}
?>
