<?php
/*
 * $Id: class.dbTickets.inc.php,v 1.4.4.3 2003/11/11 05:49:28 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');

class dbTickets extends dclDB
{
	var $ticketid;
	var $product;
	var $version;
	var $account;
	var $createdby;
	var $createdon;
	var $responsible;
	var $closedby;
	var $closedon;
	var $status;
	var $statuson;
	var $lastactionon;
	var $priority;
	var $type;
	var $contact;
	var $contactphone;
	var $summary;
	var $issue;
	var $seconds;
	var $contactemail;
	var $module_id;

	// Pseudo-field to display hh:mm:ss
	var $hoursText;

	function dbTickets()
	{
		// Table Fields
		$this->fieldArray = array(
				'ticketid', 
				'product',
				'version',
				'account', 
				'createdby', 
				'createdon',
				'responsible',
				'closedby', 
				'closedon', 
				'status', 
				'statuson', 
				'lastactionon',
				'priority',
				'type',
				'contact',
				'contactphone',
				'summary',
				'issue',
				'seconds',
				'contactemail',
				'module_id');

		// Foreign keys
		$this->foreignKeys = array();

		$this->cacheEnabled = false;
		$this->dclDB();
	}

	function Add()
	{
		global $dcl_info, $dcl_domain, $dcl_domain_info;

		if ($this->conn == 0)
		{
			if(!$this->Connect())
				return -1;
		}

		$oStatus = CreateObject('dcl.dbStatuses');

		$idSQL = $this->GetNewIDSQLForTable('tickets');
		$query  = 'INSERT INTO tickets (';
		if ($idSQL != '')
			$query .= 'ticketid,';
		$query .= 'product,version,account,createdby,createdon,responsible,';
		if ($oStatus->GetStatusType($this->status) == 2)
			$query .= 'closedby,';
		$query .= 'closedon,status,statuson,lastactionon,';
		$query .= 'priority,type,contact,contactphone,summary,issue,seconds,contactemail,module_id) VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= $this->product . ',';
		$query .= '\'' . $this->DBAddSlashes($this->version) . '\',';
		$query .= $this->account . ',';
		$query .= $this->createdby . ',';
		$query .= $this->GetDateSQL() . ',';
		$query .= $this->responsible . ',';
		if ($oStatus->GetStatusType($this->status) == 2)
		{
			$query .= $this->closedby . ',';
			$query .= $this->DisplayToSQL(date($dcl_info['DCL_TIMESTAMP_FORMAT'])) . ',';
		}
		else
			$query .= $this->emptyTimestamp . ',';
		$query .= $this->status . ',';
		$query .= $this->DisplayToSQL($this->statuson) . ',';
		if (IsSet($this->lastactionon) && $this->lastactionon != '')
			$query .= $this->DisplayToSQL($this->lastactionon) . ',';
		else
			$query .= $this->emptyTimestamp . ',';
		$query .= $this->priority . ',';
		$query .= $this->type . ',';
		$query .= '\'' . $this->DBAddSlashes($this->contact) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->contactphone) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->summary) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->issue) . '\',';
		$query .= $this->seconds . ',';
		$query .= '\'' . $this->DBAddSlashes($this->contactemail) . '\'';
		if ($this->module_id > 0)
			$query .= ',' . $this->module_id;
		else
			$query .= ',NULL';

		$query .= ')';

		if ($this->Insert($query) == -1)
			echo sprintf(STR_DB_TICKETINSERTERR, $query);
		else
		{
			if ($this->Load($this->GetLastInsertID('tickets')) == -1)
				printf(STR_DB_TICKETBYOIDERR, $this->oid);
		}
	}

	function Edit()
	{
		$query = 'UPDATE tickets SET ';
		$query .= 'product=' . $this->product . ',';
		$query .= 'version=\'' . $this->DBAddSlashes($this->version) . '\',';
		$query .= 'account=' . $this->account . ',';
		$query .= 'createdby=' . $this->createdby . ',';
		$query .= 'createdon=' . $this->DisplayToSQL($this->createdon) . ',';
		$query .= 'responsible=' . $this->responsible . ',';
		$query .= 'closedby=';
		$oStatus = CreateObject('dcl.dbStatuses');
		if ($oStatus->GetStatusType($this->status) == 2)
			$query .= $this->closedby . ',';
		else
			$query .= 'null,';
		if ($this->closedon != '')
			$query .= 'closedon=' . $this->DisplayToSQL($this->closedon) . ',';
		else
			$query .= 'closedon=' . $this->emptyTimestamp . ',';
		$query .= 'status=' . $this->status . ',';
		$query .= 'statuson=' . $this->DisplayToSQL($this->statuson) . ',';
		if ($this->lastactionon != '')
			$query .= 'lastactionon=' . $this->DisplayToSQL($this->lastactionon) . ',';
		else
			$query .= 'lastactionon=' . $this->emptyTimestamp . ',';
		$query .= 'priority=' . $this->priority . ',';
		$query .= 'type=' . $this->type . ',';
		$query .= 'contact=\'' . $this->DBAddSlashes($this->contact) . '\',';
		$query .= 'contactphone=\'' . $this->DBAddSlashes($this->contactphone) . '\',';
		$query .= 'summary=\'' . $this->DBAddSlashes($this->summary) . '\',';
		$query .= 'issue=\'' . $this->DBAddSlashes($this->issue) . '\',';
		$query .= 'seconds=' . $this->seconds . ',';
		$query .= 'contactemail=\'' . $this->DBAddSlashes($this->contactemail) . '\',';
		$query .= 'module_id=';
		if ($this->module_id > 0)
			$query .= $this->module_id;
		else
			$query .= 'NULL';
		
		$query .= ' WHERE ticketid=' . $this->ticketid;

		$this->Execute($query);
		$this->hoursText = $this->GetHoursText();
	}

	function Delete()
	{
		$this->BeginTransaction();

		$query = 'DELETE FROM ticketresolutions WHERE ticketid=' . $this->ticketid;
		$this->Execute($query);

		$query = 'DELETE FROM tickets WHERE ticketid=' . $this->ticketid;
		$this->Execute($query);

		return $this->EndTransaction();
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->ticketid = $this->f('ticketid');
			$this->product = $this->f('product');
			$this->version = $this->f('version');
			$this->account = $this->f('account');
			$this->createdby = $this->f('createdby');
			$this->createdon = $this->FormatTimestampForDisplay($this->f('createdon'));
			$this->responsible = $this->f('responsible');
			$this->closedby = $this->f('closedby');
			$this->closedon = $this->FormatTimestampForDisplay($this->f('closedon'));
			$this->status = $this->f('status');
			$this->statuson = $this->FormatTimestampForDisplay($this->f('statuson'));
			$this->lastactionon = $this->FormatTimestampForDisplay($this->f('lastactionon'));
			$this->priority = $this->f('priority');
			$this->type = $this->f('type');
			$this->contact = $this->f('contact');
			$this->contactphone = $this->f('contactphone');
			$this->summary = $this->f('summary');
			$this->issue = $this->f('issue');
			$this->seconds = $this->f('seconds');
			$this->contactemail = $this->f('contactemail');
			$this->module_id = $this->f('module_id');

			$this->hoursText = $this->GetHoursText();
		}
		else
			$this->Clear();
	}

	function GetHoursText()
	{
		// Set hoursText
		if ($this->res > 0 && count($this->Record) > 0)
		{
			$tempHours = $this->f('seconds');
		}
		else
			$tempHours = $this->seconds;

		$hh = intval($tempHours / 3600);
		$tempHours -= ($hh * 3600);
		$mm = intval($tempHours / 60);
		$tempHours -= ($mm * 60);
		$ss = intval($tempHours);

		return sprintf('%01d:%02d:%02d', $hh, $mm, $ss);
	}

	function Load($ticketid)
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT ticketid, product, version, account, createdby, ';
		$sql .= $this->ConvertTimestamp('createdon', 'createdon');
		$sql .= ', responsible, closedby, ';
		$sql .= $this->ConvertTimestamp('closedon', 'closedon');
		$sql .= ', status, ';
		$sql .= $this->ConvertTimestamp('statuson', 'statuson');
		$sql .= ', ' . $this->ConvertTimestamp('lastactionon', 'lastactionon');
		$sql .= ', priority, type, contact, contactphone, summary, issue, seconds, contactemail, module_id';
		$sql .= " FROM tickets WHERE ticketid=$ticketid";
		if (!$this->Query($sql))
			return -1;

		if (!$this->next_record())
			return -1;

		return $this->GetRow();
	}

	function LoadDatesByRange($beginDate, $endDate, $product_id = 0)
	{
		$query = 'SELECT ';
		$query .= $this->ConvertTimestamp('createdon', 'createdon');
		$query .= ', ';
		$query .= $this->ConvertTimestamp('closedon', 'closedon');
		$query .= ' FROM tickets WHERE ((createdon between ' . $this->DisplayToSQL($beginDate);
		$query .= ' AND ' . $this->DisplayToSQL($endDate);
		$query .= ') OR (closedon between ' . $this->DisplayToSQL($beginDate);
		$query .= ' AND ' . $this->DisplayToSQL($endDate) . '))';

		if ($product_id > 0)
			$query .= ' AND product = ' . $product_id;

		if (!$this->Query($query))
			return -1;
	}

	function Clear()
	{
		$this->ticketid = 0;
		$this->product = 0;
		$this->version = '';
		$this->account = 0;
		$this->createdby = 0;
		$this->createdon = '';
		$this->responsible = 0;
		$this->closedby = 0;
		$this->closedon = '';
		$this->status = 0;
		$this->statuson = '';
		$this->lastactionon = '';
		$this->priority = 0;
		$this->type = 0;
		$this->contact = '';
		$this->contactphone = '';
		$this->summary = '';
		$this->issue = '';
		$this->seconds = 0;
		$this->contactemail = '';
		$this->module_id = 0;
	}
}
?>
