<?php
/*
 * $Id: class.dbProjects.inc.php,v 1.5.4.2 2003/05/30 03:56:39 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');

class dbProjects extends dclDB
{
	var $projectid;
	var $name;
	var $reportto;
	var $createdby;
	var $createdon;
	var $projectdeadline;
	var $description;
	var $status;
	var $lastactivity;
	var $finalclose;
	var $parentprojectid;

	function dbProjects()
	{
           // Table Fields
		$this->fieldArray = array('projectid', 'name', 'reportto', 'createdby', 'createdon', 'projectdeadline', 'description', 'status', 'lastactivity', 'finalclose', 'parentprojectid');

           // Foreign keys
		$this->foreignKeys = array();

		$this->cacheEnabled = false;
		$this->dclDB();
	}

	function Add()
	{
		global $dcl_info, $dcl_domain_info, $dcl_domain;

		if ($this->conn == 0)
		{
			if(!$this->Connect())
				return -1;
		}

		$idSQL = $this->GetNewIDSQLForTable('dcl_projects');
		$this->status = $dcl_info['DCL_DEFAULT_PROJECT_STATUS'];
		$query  = 'INSERT INTO dcl_projects (';
		if ($idSQL != '')
			$query .= 'projectid,';
		$query .= 'name,reportto,createdby,createdon,';
		if ($this->projectdeadline != '')
			$query .= 'projectdeadline,';
		$query .= 'description,status,parentprojectid) VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= '\'' . $this->DBAddSlashes($this->name) . '\',' . $this->reportto;
		$query .= ',' . $this->createdby . ',';
		$query .= $this->DisplayToSQL(date($dcl_info['DCL_TIMESTAMP_FORMAT'])) . ',';
		if ($this->projectdeadline != '')
			$query .= $this->DisplayToSQL($this->projectdeadline) . ',';
		$query .= '\'' . $this->DBAddSlashes($this->description) . '\',';
		$query .= $this->status . ',';
		$query .= $this->parentprojectid . ')';

		if ($this->Insert($query) == -1)
			echo sprintf(STR_DB_PROJECTINSERTERR, $query);
		else
		{
			if ($this->Load($this->GetLastInsertID('dcl_projects')) == -1)
				printf(STR_DB_PROJECTBYOIDERR, $this->oid);
		}
	}

	function Edit()
	{
		$query = 'UPDATE dcl_projects SET ';
		$query .= 'name=\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= 'createdon=' . $this->DisplayToSQL($this->createdon) . ',';
		$query .= 'reportto=\'' . $this->reportto . '\',';
		$query .= 'projectdeadline=';
		if ($this->projectdeadline != '')
			$query .= $this->DisplayToSQL($this->projectdeadline) . ',';
		else
			$query .= 'null,';
		$query .= 'description=\'' . $this->DBAddSlashes($this->description) . '\',';
		$query .= 'status=' . $this->status . ',';
		$query .= 'lastactivity=';
		if ($this->lastactivity != '')
			$query .= $this->DisplayToSQL($this->lastactivity) . ',';
		else
			$query .= $this->emptyTimestamp . ',';
		$query .= 'finalclose=';
		if ($this->finalclose != '')
			$query .= $this->DisplayToSQL($this->finalclose) . ',';
		else
			$query .= 'NULL,';
		$query .= 'parentprojectid=' . $this->parentprojectid;
		$query .= ' WHERE projectid=' . $this->projectid;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM projectmap WHERE projectid=' . $this->projectid;
		$this->Execute($query);
		$query = 'DELETE FROM dcl_projects WHERE projectid=' . $this->projectid;
		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res || count($this->Record) < 1)
			return -1;

		$this->projectid = $this->f('projectid');
		$this->name = $this->f('name');
		$this->reportto = $this->f('reportto');
		$this->createdby = $this->f('createdby');
		$this->createdon = $this->FormatTimestampForDisplay($this->f('createdon'));
		$this->projectdeadline = $this->FormatDateForDisplay($this->f('projectdeadline'));
		$this->description = $this->f('description');
		$this->status = $this->f('status');
		$this->lastactivity = $this->FormatTimestampForDisplay($this->f('lastactivity'));
		$this->finalclose = $this->FormatDateForDisplay($this->f('finalclose'));
		$this->parentprojectid = $this->f('parentprojectid');
	}

	function ParentIsNotChild($projectid, $parentid)
	{
		$isNotChild = true;
		$db = new dclDB;
		$db->Connect($this->conn);

		if ($db->Query("SELECT projectid FROM dcl_projects WHERE parentprojectid=$projectid") != -1)
		{
			while ($db->next_record() && $isNotChild)
			{
				if ($this->f(0) == $parentid)
					$isNotChild = false;
				else
					$isNotChild = $this->ParentIsNotChild($this->f(0), $parentid);
			}

			$db->FreeResult();
		}

		return $isNotChild;
	}

	function GetProjectParents($projectid, $includethis = false)
	{
		$obj = new dclDB;
		$obj->Connect($this->conn);

		if ($includethis == false)
			$projectids = '';
		else
			$projectids = $projectid;

		if ($obj->Query("SELECT parentprojectid FROM dcl_projects WHERE projectid =$projectid") != -1)
		{
			while ($obj->next_record())
			{
				$parent_id = $obj->f(0);
				$obj->FreeResult();

				if ($parent_id == 0 || $parent_id == null)
					return $projectids;

				if ($projectids != '')
					$projectids .= ',';

				$projectids .= $this->GetProjectParents($parent_id, true);
			}
		}

		return $projectids;
	}


	function GetProjectChildren($projectid, $includethis = false)
	{
		$obj = new dclDB;
		$obj->Connect($this->conn);

		if ($includethis == false)
			$projectids = '';
		else
			$projectids = $projectid;

		if ($obj->Query("SELECT projectid FROM dcl_projects WHERE parentprojectid=$projectid") != -1)
		{
			while ($obj->next_record())
			{
				if(($obj->cur > 1) || $includethis)
					$projectids .= ',';

				$projectids .= $this->GetProjectChildren($obj->f(0), true);
			}

			$obj->FreeResult();
		}

		return $projectids;
	}

	function GetProjectStatistics($projectid, $includeChildren = false, $includeParents = false)
	{
		$retval = array(
				'totaltasks' => 0,
				'esthours' => 0.0,
				'totalhours' => 0.0,
				'etchours' => 0.0,
				'resources' => 0,
				'tasksclosed' => 0
			);

		$obj = new dclDB;
		$obj->Connect($this->conn);

		$projectids = $projectid;

		if ($includeChildren)
		{
			$children = $this->GetProjectChildren($projectid);
			if($children != '')
				$projectids .= ",".$children;
		}

		if ($includeParents)
		{
			$parents = $this->GetProjectParents($projectid);
			if($parents != '')
				$projectids .= ",".$parents;
		}

		$sql = 'SELECT count(*),sum(esthours),sum(totalhours),sum(etchours) FROM workorders a, projectmap b WHERE ';
		$sql .= "a.jcn=b.jcn AND (b.seq=0 OR a.seq=b.seq) AND b.projectid in ($projectids) ";
		if ($obj->Query($sql) != -1)
		{
			if ($obj->next_record())
			{
				$retval['totaltasks'] = $obj->f(0);
				$retval['esthours'] = $obj->f(1);
				$retval['totalhours'] = $obj->f(2);
				$retval['etchours'] = $obj->f(3);
			}

			$obj->FreeResult();
		}

		$sql = 'SELECT distinct responsible FROM workorders a, projectmap b, statuses c WHERE ';
		$sql .= "a.jcn=b.jcn AND (b.seq=0 OR a.seq=b.seq) AND b.projectid in ($projectids) AND a.status=c.id AND c.dcl_status_type!=2";
		if ($obj->Query($sql) != -1)
		{
			// spin through results to get count - Oracle has no numrows and mysql doesn't support count(distinct) in older versions :-(
			while ($obj->next_record())
				$retval['resources']++;

			$obj->FreeResult();
		}

		$sql = 'SELECT count(*) FROM workorders a, projectmap b, statuses c WHERE ';
		$sql .= "a.jcn=b.jcn AND (b.seq=0 OR a.seq=b.seq) AND b.projectid in ($projectids) AND a.status=c.id AND c.dcl_status_type=2";
		if ($obj->Query($sql) != -1)
		{
			if ($obj->next_record())
				$retval['tasksclosed'] = $obj->f(0);

			$obj->FreeResult();
		}

		return $retval;
	}

	function Load($projectid)
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$projectid = (int)$projectid;
		if ($projectid < 1)
			return -1;

		$sql = 'SELECT projectid, name, reportto, createdby, ';
		$sql .= $this->ConvertTimestamp('createdon', 'createdon');
		$sql .= ', ' . $this->ConvertDate('projectdeadline', 'projectdeadline');
		$sql .= ', description, status, ';
		$sql .= $this->ConvertTimestamp('lastactivity', 'lastactivity');
		$sql .= ', ' . $this->ConvertDate('finalclose', 'finalclose');
		$sql .= ", parentprojectid FROM dcl_projects WHERE projectid = $projectid";
		if (!$this->Query($sql))
			return -1;

		if (!$this->next_record())
			return -1;

		return $this->GetRow();
	}

	function Exists($sName)
	{
		$obj = new dclDB;
		$obj->Connect();
		$obj->Query('SELECT count(*) FROM dcl_projects WHERE ' . $this->GetUpperSQL('name') . '=\'' . strtoupper($sName) . '\'');
		$obj->next_record();
		return ($obj->f(0) > 0);
	}

	function Clear()
	{
		$this->projectid = 0;
		$this->name = '';
		$this->reportto = 0;
		$this->createdby = 0;
		$this->createdon = '';
		$this->projectdeadline = '';
		$this->description = '';
		$this->status = 0;
		$this->lastactivity = '';
		$this->finalclose = '';
		$this->parentprojectid = 0;
	}
}
?>
