<?php
/*
 * $Id: class.boFile.inc.php,v 1.1.2.1.2.2 2003/05/02 05:25:51 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');

define('ATTACHMENT_WORKORDER', 1);
define('ATTACHMENT_TICKET', 2);
define('ATTACHMENT_PROJECT', 3);

class boFile
{
	var $iType;
	var $iKey1;
	var $iKey2;
	var $sFileName;
	var $sTempFileName;
	var $sRoot;

	function IsValid()
	{
		return ($this->iType >= ATTACHMENT_WORKORDER && $this->iType <= ATTACHMENT_PROJECT);
	}

	function Download()
	{
		if (!$this->IsValid())
			return;

		if (file_exists($this->GetFilePath()))
		{
			$hFile = fopen($this->GetFilePath(), 'rb');
			if ($hFile)
			{
				// Output the file and nothing else
				$hdr =  'Content-Type: application/binary; name=' . $this->sFileName . phpCrLf;
				$hdr .= 'Content-Disposition: attachment; filename=' . $this->sFileName . phpCrLf . phpCrLf;

				header($hdr);
				fpassthru($hFile);
				exit;
			}
		}
	}

	function Upload()
	{
		if (!$this->IsValid() || $this->sTempFileName == '' || $this->sTempFileName == 'none')
			return;

		if (!copy($this->sTempFileName, $this->GetFilePath()))
			echo STR_BO_UPLOADERR;
	}

	function AddPath($sPath, $sDir)
	{
		$retVal = $sPath . '/' . $sDir;
		if (!is_dir($retVal))
			mkdir($retVal, 0750);
		return $retVal;
	}

	function GetFilePath()
	{
		$retVal = $this->sRoot;
		switch($this->iType)
		{
			case ATTACHMENT_WORKORDER:
				$retVal = $this->AddPath($retVal, 'wo');
				$retVal = $this->AddPath($retVal, substr($this->iKey1, -1));
				$retVal = $this->AddPath($retVal, $this->iKey1);
				$retVal = $this->AddPath($retVal, $this->iKey2);
				break;
			case ATTACHMENT_TICKET:
				$retVal = $this->AddPath($retVal, 'tck');
				$retVal = $this->AddPath($retVal, substr($this->iKey1, -1));
				$retVal = $this->AddPath($retVal, $this->iKey1);
				break;
			case ATTACHMENT_PROJECT:
				$retVal = $this->AddPath($retVal, 'prj');
				$retVal = $this->AddPath($retVal, substr($this->iKey1, -1));
				$retVal = $this->AddPath($retVal, $this->iKey1);
				break;
		}

// get last / or \ to preven file download spoofing
		$last_back = strrpos($this->sFileName,"\\");
		$last_forward = strrpos($this->sFileName,"/");

// find out which is last / or \ if either exists
		if($last_forward > $last_back)
			{
			$pos = $last_forward;
			}
		else
			{
			$pos = $last_back;
			}

// determine if $pos is valid and if so clean the file 
// (might be better way to do this but found conflicting stories
// about what works in php3 vs php4

		if(!$pos)
			{
			$retVal .= '/' . $this->sFileName;
			}
		else	
			{
			$clean_file = substr($this->sFileName, ($pos + 1), (strlen($this->sFileName)-$pos));
			$retVal .= '/' . $clean_file;
			}

		return $retVal;
	}
}
?>
