;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/input.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Aug  4 15:42:25 1992                          */
;*    Last change :  Wed Sep 17 05:23:14 2003 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.10.2 Input (page 30, r4)                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_input_6_10_2
   
   (import  __error
	    __r4_ports_6_10_1)
   
   (use     __type
	    __bigloo
	    __tvector
	    
	    __rgc
	    
	    __r4_output_6_10_3
	    __r4_equivalence_6_2
	    __r4_vectors_6_8
	    __r4_booleans_6_1
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_strings_6_7
	    __r4_control_features_6_9
	    __r4_characters_6_6
	    __r4_symbols_6_4
	    __r4_pairs_and_lists_6_3
	    
	    __evenv)
   
   (extern  (macro c-eof-object?::bool (::obj) "EOF_OBJECTP")
	    (c-char-ready?::bool (::input-port) "bgl_rgc_charready")
	    (c-sendchars::obj (::input-port ::output-port ::int)
			      "bgl_sendchars")
	    (macro beof::obj "BEOF"))
   
   (java    (class foreign
	       (method static c-eof-object?::bool (::obj) "EOF_OBJECTP")
	       (method static c-char-ready?::bool (::input-port) "bgl_rgc_charready")
	       (method static c-sendchars::obj (::input-port ::output-port ::int)
		   "bgl_sendchars")
	       (field static beof::obj "BEOF")))
   
   (export  (inline read/rp    ::procedure ::input-port)
	    (inline read/lalrp ::procedure ::procedure ::input-port . obj)
	    
	    (read-char . port)
	    (peek-char . port)
	    (inline eof-object?::bool ::obj)
	    (inline char-ready?::bool . port)
	    (read-line::obj . input-port)
	    (read-lines::pair-nil . input-port)
	    (read-string::bstring . input-port)
	    (read-of-strings::obj . input-port)
	    (read-chars::obj ::int . port)
	    (read-fill-string!::int ::bstring ::int ::int . port)
	    *about-to-read*
	    (send-chars::int ::input-port ::output-port . obj))
   
   (pragma  (eof-object? side-effect-free nesting args-safe)
	    (char-ready? side-effect-free args-safe)))

;*---------------------------------------------------------------------*/
;*    read/rp ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (read/rp grammar port)
   (grammar port #f))

;*---------------------------------------------------------------------*/
;*    read/lalr ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (read/lalrp lalr rgc port . eof-fun?)
   (if (null? eof-fun?)
       (lalr rgc port eof-object?)
       (lalr rgc port (car eof-fun?))))

;*---------------------------------------------------------------------*/
;*    read-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-char . ip)
   (let ((grammar (regular-grammar ()
		     ((in all #\Newline)
		      (the-character)))))
      (read/rp grammar (if (null? ip) (current-input-port) (car ip)))))

;*---------------------------------------------------------------------*/
;*    peek-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (peek-char . ip)
   (let ((grammar (regular-grammar ()
		     ((in all #\Newline)
		      (let ((c (the-character)))
			 (rgc-buffer-unget-char (the-port) (char->integer c))
			 c)))))
      (read/rp grammar (if (null? ip) (current-input-port) (car ip)))))

;*---------------------------------------------------------------------*/
;*    eof-object? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (eof-object? object)
   (c-eof-object? object))

;*---------------------------------------------------------------------*/
;*    char-ready? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (char-ready? . port)
   (c-char-ready? (if (pair? port) (car port) (current-input-port))))

;*---------------------------------------------------------------------*/
;*    read-line ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-line . input-port)
   (let ((port (if (pair? input-port) (car input-port) (current-input-port))))
      (if (>fx (c-input-port-bufsiz port) 2)
	  (let ((grammar (regular-grammar ((xall (or (out #\Newline #\Return)
						     #a000)))
			    ((: (+ xall) (or #\Newline #\Return))
			     (the-substring 0 (-fx (the-length) 1)))
			    ((: (+ xall) #\Return #\Newline)
			     (the-substring 0 (-fx (the-length) 2)))
			    ((+ xall)
			     (the-string))
			    ((or #\Newline #\Return (: #\Return #\Newline))
			     "")
			    (else
			     (the-failure)))))
	     (read/rp grammar port))
	  ;; IOs are unbufferized, uses read-char to get the
	  ;; characters one by one
	  (let loop ((c (read-char port))
		     (w 0)
		     (m 80)
		     (acc (make-string 80)))
	     (cond
		((eof-object? c)
		 ;; shrink the buffer and return 
		 (if (=fx w 0)
		     c
		     (substring acc 0 w)))
		((or (char=? c #\Newline) (char=? c #\Return))
		 ;; shrink the buffer and return 
		 (substring acc 0 w))
		((=fx w m)
		 ;; enlarge the buffer
		 (loop c
		       w
		       (*fx m 2)
		       (let ((new-acc (make-string (*fx m 2))))
			  (blit-string! acc 0
					new-acc 0
					m)
			  new-acc)))
		(else
		 ;; fill the buffer
		 (string-set! acc w c)
		 (loop (read-char port)
		       (+fx w 1)
		       m
		       acc)))))))

;*---------------------------------------------------------------------*/
;*    read-lines ...                                                   */
;*---------------------------------------------------------------------*/
(define (read-lines . input-port)
   (let ((port (if (pair? input-port) (car input-port) (current-input-port))))
      (let loop ((l (read-line port))
		 (ls '()))
	 (if (eof-object? l)
	     (reverse! ls)
	     (loop (read-line port) (cons l ls))))))

;*---------------------------------------------------------------------*/
;*    read-string ...                                                  */
;*---------------------------------------------------------------------*/
(define (read-string . input-port)
   (let ((port (if (pair? input-port) (car input-port) (current-input-port))))
      (read/rp (regular-grammar ()
		  ((+ (or all #\Newline)) (the-string))
		  (else ""))
	       port)))
   
;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define *read-of-strings-grammar*
   (regular-grammar ()
      ((+ (in #\space #\tab #\newline))
       (ignore))
      ((+ (out #\space #\tab #\newline))
       (the-string))))

;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define (read-of-strings . input-port)
   (let ((port (if (pair? input-port) (car input-port) (current-input-port))))
      (read/rp *read-of-strings-grammar* port)))

;*---------------------------------------------------------------------*/
;*    read-chars ...                                                   */
;*---------------------------------------------------------------------*/
(define (read-chars len . input-port)
   (let* ((s (c-make-string/wo-fill len))
	  (p (if (pair? input-port) (car input-port) (current-input-port)))
	  (n (_rgc-blit-string! p s 0 len)))
      (cond
	 ((=fx n 0)
	  (if (rgc-buffer-eof? p)
	      beof
	      ""))
	 ((<fx n len)
	  (string-shrink! s n))
	 (else
	  s))))

;*---------------------------------------------------------------------*/
;*    read-fill-string! ...                                            */
;*---------------------------------------------------------------------*/
(define (read-fill-string! s o len . input-port)
   (let ((port (if (pair? input-port) (car input-port) (current-input-port))))
      (_rgc-blit-string! port s o len)))
   
;*---------------------------------------------------------------------*/
;*    *about-to-read* ...                                              */
;*---------------------------------------------------------------------*/
(define *about-to-read* #unspecified)

;*---------------------------------------------------------------------*/
;*    send-chars ...                                                   */
;*---------------------------------------------------------------------*/
(define (send-chars input::input-port output::output-port . obj)
   (let ((size (if (null? obj) -1 (car obj))))
      (or (c-sendchars input output size)
	  (let* ((bufsize (if (=fx size -1)
			      c-default-io-bufsiz
			      (if (<fx c-default-io-bufsiz size)
				  c-default-io-bufsiz
				  size)))
		 (buffer (make-string bufsize))
		 (chars-to-read bufsize)
		 (chars-read 0))
	     (let loop ()
		(if (=fx chars-to-read 0)
		    chars-read
		    (let ((n (read-fill-string! buffer
						0
						chars-to-read
						input)))
		       (set! chars-read (+fx chars-read n))
		       (cond
			  ((=fx 0 n)
			   (set! chars-to-read 0))
			  ((not (=fx -1 size))
			   (set! size (-fx size n))
			   (set! chars-to-read
				 (if (<fx size bufsize)
				     size
				     bufsize))))
		       (if (=fx bufsize n)
			   (display buffer output)
			   (display (substring buffer 0 n) output))
		       (loop))))))))
