;*=====================================================================*/
;*    serrano/prgm/project/bigloo/fthread/src/condvar.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb 18 14:10:57 2002                          */
;*    Last change :  Wed Nov 20 11:30:25 2002 (serrano)                */
;*    Copyright   :  2002 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    Condition variables                                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __ft_condition-variable
   
   (import __ft_types
	   __ft_%types
	   __ft_scheduler)
   
   (export (make-condition-variable::condition-variable . name)
	   
	   (condition-variable-signal! ::condition-variable)
	   (condition-variable-broadcast! ::condition-variable)))
	   
;*---------------------------------------------------------------------*/
;*    make-condition-variable ...                                      */
;*---------------------------------------------------------------------*/
(define (make-condition-variable . name)
   (instantiate::%condition-variable
      (name (if (pair? name) (car name) (gensym 'condition-variable)))))

;*---------------------------------------------------------------------*/
;*    condition-variable-signal! ...                                   */
;*---------------------------------------------------------------------*/
(define (condition-variable-signal! cv)
   (condition-variable-broadcast! cv))

;*---------------------------------------------------------------------*/
;*    condition-variable-broadcast! ...                                */
;*---------------------------------------------------------------------*/
(define (condition-variable-broadcast! cv)
   (broadcast! cv))


	      
	   
