/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene101;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene101.Lucene101PostingsReader;
import org.apache.lucene.backward_codecs.lucene90.blocktree.Lucene90BlockTreeTermsReader;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.util.IOUtils;

public class Lucene101PostingsFormat
extends PostingsFormat {
    public static final String META_EXTENSION = "psm";
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    public static final int BLOCK_SIZE = 128;
    public static final int LEVEL1_FACTOR = 32;
    public static final int LEVEL1_NUM_DOCS = 4096;
    static final int LEVEL1_MASK = 4095;
    static final String TERMS_CODEC = "Lucene90PostingsWriterTerms";
    static final String META_CODEC = "Lucene101PostingsWriterMeta";
    static final String DOC_CODEC = "Lucene101PostingsWriterDoc";
    static final String POS_CODEC = "Lucene101PostingsWriterPos";
    static final String PAY_CODEC = "Lucene101PostingsWriterPay";
    static final int VERSION_START = 0;
    static final int VERSION_DENSE_BLOCKS_AS_BITSETS = 1;
    static final int VERSION_CURRENT = 1;

    public static Class<? extends ImpactsEnum> getImpactsEnumImpl() {
        return Lucene101PostingsReader.BlockPostingsEnum.class;
    }

    public Lucene101PostingsFormat() {
        super("Lucene101");
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        throw new UnsupportedOperationException("This postings format may not be used for writing, use the current postings format");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        Lucene90BlockTreeTermsReader lucene90BlockTreeTermsReader;
        block3: {
            Lucene101PostingsReader postingsReader = new Lucene101PostingsReader(state);
            boolean success = false;
            try {
                Lucene90BlockTreeTermsReader ret = new Lucene90BlockTreeTermsReader(postingsReader, state);
                success = true;
                lucene90BlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsReader});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsReader});
        }
        return lucene90BlockTreeTermsReader;
    }

    public static final class IntBlockTermState
    extends BlockTermState {
        public long docStartFP;
        public long posStartFP;
        public long payStartFP;
        public long lastPosBlockOffset = -1L;
        public int singletonDocID = -1;

        public IntBlockTermState clone() {
            IntBlockTermState other = new IntBlockTermState();
            other.copyFrom((TermState)this);
            return other;
        }

        public void copyFrom(TermState _other) {
            super.copyFrom(_other);
            IntBlockTermState other = (IntBlockTermState)_other;
            this.docStartFP = other.docStartFP;
            this.posStartFP = other.posStartFP;
            this.payStartFP = other.payStartFP;
            this.lastPosBlockOffset = other.lastPosBlockOffset;
            this.singletonDocID = other.singletonDocID;
        }

        public String toString() {
            return super.toString() + " docStartFP=" + this.docStartFP + " posStartFP=" + this.posStartFP + " payStartFP=" + this.payStartFP + " lastPosBlockOffset=" + this.lastPosBlockOffset + " singletonDocID=" + this.singletonDocID;
        }
    }
}

