/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.keystore;

import joptsimple.OptionSet;
import org.opensearch.cli.Terminal;
import org.opensearch.cli.UserException;
import org.opensearch.common.settings.KeyStoreWrapper;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.env.Environment;
import org.opensearch.tools.cli.keystore.BaseKeyStoreCommand;

public class ChangeKeyStorePasswordCommand
extends BaseKeyStoreCommand {
    ChangeKeyStorePasswordCommand() {
        super("Changes the password of a keystore", true);
    }

    @Override
    protected void executeCommand(Terminal terminal, OptionSet options, Environment env) throws Exception {
        try (SecureString newPassword = ChangeKeyStorePasswordCommand.readPassword(terminal, true);){
            KeyStoreWrapper keyStore = this.getKeyStore();
            keyStore.save(env.configDir(), newPassword.getChars());
            terminal.println("OpenSearch keystore password changed successfully.");
        }
        catch (SecurityException e) {
            throw new UserException(65, e.getMessage());
        }
    }
}

