/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapNavigationUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class SelectFilteredNodesAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final FilterController filterController;

    SelectFilteredNodesAction(FilterController filterController) {
        super("SelectFilteredNodesAction");
        this.filterController = filterController;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.filterController.isFilterActive()) {
            return;
        }
        IMapSelection selection = Controller.getCurrentController().getSelection();
        MapController mapController = Controller.getCurrentModeController().getMapController();
        NodeModel selected = selection.getSelected();
        NodeModel rootNode = selection.getSelectionRoot();
        Filter filter = selection.getFilter();
        boolean nodeFound = filter.getFilterInfo(rootNode).isMatched();
        if (nodeFound) {
            selection.selectAsTheOnlyOneSelected(rootNode);
        }
        NodeModel next = rootNode;
        while ((next = MapNavigationUtils.findNext(MapController.Direction.FORWARD, next, rootNode)) != null) {
            if (next.isHiddenSummary() || !filter.getFilterInfo(next).isMatched()) continue;
            mapController.displayNode(next);
            if (nodeFound) {
                selection.toggleSelected(next);
                continue;
            }
            selection.selectAsTheOnlyOneSelected(next);
            nodeFound = true;
        }
        if (filter.getFilterInfo(selected).isMatched()) {
            selection.makeTheSelected(selected);
        }
    }
}

