/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.property;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.property.GetProperty;
import org.apache.tools.ant.property.ParseProperties;

public class ResolvePropertyMap
implements GetProperty {
    private final Set seen = new HashSet();
    private final ParseProperties parseProperties;
    private final GetProperty master;
    private Map map;
    private String prefix;

    public ResolvePropertyMap(Project project, GetProperty master, Collection expanders) {
        this.master = master;
        this.parseProperties = new ParseProperties(project, expanders, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        Object masterProperty;
        if (this.seen.contains(name)) {
            throw new BuildException("Property " + name + " was circularly " + "defined.");
        }
        String masterPropertyName = name;
        if (this.prefix != null) {
            masterPropertyName = this.prefix + name;
        }
        if ((masterProperty = this.master.getProperty(masterPropertyName)) != null) {
            return masterProperty;
        }
        try {
            this.seen.add(name);
            Object object = this.parseProperties.parseProperties((String)this.map.get(name));
            return object;
        }
        finally {
            this.seen.remove(name);
        }
    }

    public void resolveAllProperties(Map map) {
        this.resolveAllProperties(map, null);
    }

    public void resolveAllProperties(Map map, String prefix) {
        this.map = map;
        this.prefix = prefix;
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object result = this.getProperty(key);
            String value = result == null ? "" : result.toString();
            map.put(key, value);
        }
    }
}

