/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.query;

import ca.sqlpower.query.Container;
import ca.sqlpower.query.Item;
import ca.sqlpower.query.QueryImpl;
import ca.sqlpower.query.SQLGroupFunction;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.UUID;
import org.apache.log4j.Logger;

public abstract class AbstractItem
implements Item {
    private static final Logger logger = Logger.getLogger(AbstractItem.class);
    private Integer columnWidth;
    private String uuid;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Container parent;
    private String name;
    private Integer selected;
    private SQLGroupFunction groupBy = SQLGroupFunction.GROUP_BY;
    private String having;
    private QueryImpl.OrderByArgument orderBy = QueryImpl.OrderByArgument.NONE;
    private Integer orderByOrdering;

    public AbstractItem() {
        this.uuid = "w" + UUID.randomUUID();
    }

    public AbstractItem(String uuid) {
        this.uuid = uuid == null ? "w" + UUID.randomUUID() : uuid;
    }

    @Override
    public void setColumnWidth(Integer width) {
        Integer oldWidth = this.columnWidth;
        this.columnWidth = width;
        this.pcs.firePropertyChange("columnWidth", oldWidth, width);
    }

    @Override
    public Integer getColumnWidth() {
        return this.columnWidth;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Firing property change \"" + propertyName + "\" to " + this.pcs.getPropertyChangeListeners().length + " listeners: " + Arrays.toString(this.pcs.getPropertyChangeListeners())));
        }
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Container parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public void setGroupBy(SQLGroupFunction groupBy) {
        SQLGroupFunction oldGroupBy = this.groupBy;
        this.groupBy = groupBy;
        this.firePropertyChange("groupBy", (Object)oldGroupBy, (Object)groupBy);
    }

    @Override
    public SQLGroupFunction getGroupBy() {
        return this.groupBy;
    }

    @Override
    public void setHaving(String having) {
        String oldHaving = this.having;
        this.having = having;
        this.firePropertyChange("having", oldHaving, having);
    }

    @Override
    public String getHaving() {
        return this.having;
    }

    @Override
    public void setOrderBy(QueryImpl.OrderByArgument orderBy) {
        if (orderBy == null) {
            throw new IllegalArgumentException("The order by value of a column should not be set to null");
        }
        QueryImpl.OrderByArgument oldOrder = this.orderBy;
        this.orderBy = orderBy;
        this.firePropertyChange("orderBy", (Object)oldOrder, (Object)orderBy);
    }

    @Override
    public QueryImpl.OrderByArgument getOrderBy() {
        return this.orderBy;
    }

    @Override
    public Integer getSelected() {
        return this.selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected != null;
    }

    @Override
    public void setSelected(Integer selected) {
        Integer oldSelect = this.selected;
        this.selected = selected;
        this.firePropertyChange("selected", oldSelect, selected);
    }

    @Override
    public void setOrderByOrdering(Integer ordering) {
        Integer oldOrdering = this.orderByOrdering;
        this.orderByOrdering = ordering;
        this.firePropertyChange("orderByOrdering", oldOrdering, ordering);
    }

    @Override
    public Integer getOrderByOrdering() {
        return this.orderByOrdering;
    }
}

