/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.filecompare;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.filecompare.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryFileCompare
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String filename1;
    private String filename2;
    private boolean addFilenameToResult;

    public JobEntryFileCompare(String n) {
        super(n, "");
        this.filename1 = null;
        this.filename2 = null;
        this.addFilenameToResult = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.FILE_COMPARE);
    }

    public JobEntryFileCompare() {
        this("");
    }

    public JobEntryFileCompare(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryFileCompare je = (JobEntryFileCompare)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename1", (String)this.filename1));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename2", (String)this.filename2));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_filename_result", (boolean)this.addFilenameToResult));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename1 = XMLHandler.getTagValue((Node)entrynode, (String)"filename1");
            this.filename2 = XMLHandler.getTagValue((Node)entrynode, (String)"filename2");
            this.addFilenameToResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_filename_result"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobEntryFileCompare.ERROR_0001_Unable_To_Load_From_Xml_Node"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.filename1 = rep.getJobEntryAttributeString(id_jobentry, "filename1");
            this.filename2 = rep.getJobEntryAttributeString(id_jobentry, "filename2");
            this.addFilenameToResult = rep.getJobEntryAttributeBoolean(id_jobentry, "add_filename_result");
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobEntryFileCompare.ERROR_0002_Unable_To_Load_Job_From_Repository", Long.toString(id_jobentry)), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "filename1", this.filename1);
            rep.saveJobEntryAttribute(id_job, this.getID(), "filename2", this.filename2);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_filename_result", this.addFilenameToResult);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryFileCompare.ERROR_0003_Unable_To_Save_Job", Long.toString(id_job)), (Throwable)dbe);
        }
    }

    public String getRealFilename1() {
        return this.environmentSubstitute(this.getFilename1());
    }

    public String getRealFilename2() {
        return this.environmentSubstitute(this.getFilename2());
    }

    protected boolean equalFileContents(FileObject file1, FileObject file2) throws IOException {
        DataInputStream in1 = new DataInputStream(new BufferedInputStream(KettleVFS.getInputStream((String)KettleVFS.getFilename((FileObject)file1))));
        DataInputStream in2 = new DataInputStream(new BufferedInputStream(KettleVFS.getInputStream((String)KettleVFS.getFilename((FileObject)file2))));
        while (in1.available() != 0 && in2.available() != 0) {
            char ch2;
            char ch1 = (char)in1.readByte();
            if (ch1 == (ch2 = (char)in2.readByte())) continue;
            return false;
        }
        return in1.available() == in2.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        Result result;
        block23: {
            FileObject file2;
            FileObject file1;
            String realFilename2;
            LogWriter log;
            block22: {
                log = LogWriter.getInstance();
                result = previousResult;
                result.setResult(false);
                String realFilename1 = this.getRealFilename1();
                realFilename2 = this.getRealFilename2();
                file1 = null;
                file2 = null;
                if (this.filename1 != null && this.filename2 != null) {
                    file1 = KettleVFS.getFileObject((String)realFilename1);
                    file2 = KettleVFS.getFileObject((String)realFilename2);
                    if (file1.exists() && file2.exists()) {
                        if (this.equalFileContents(file1, file2)) {
                            result.setResult(true);
                        } else {
                            result.setResult(false);
                        }
                        if (this.addFilenameToResult && file1.getType() == FileType.FILE && file2.getType() == FileType.FILE) {
                            ResultFile resultFile = new ResultFile(0, file1, parentJob.getJobname(), this.toString());
                            resultFile.setComment(Messages.getString("JobWaitForFile.FilenameAdded"));
                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                            resultFile = new ResultFile(0, file2, parentJob.getJobname(), this.toString());
                            resultFile.setComment(Messages.getString("JobWaitForFile.FilenameAdded"));
                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        }
                    } else {
                        if (!file1.exists()) {
                            log.logError(this.toString(), Messages.getString("JobEntryFileCompare.ERROR_0004_File1_Does_Not_Exist", realFilename1), new Object[0]);
                        }
                        if (!file2.exists()) {
                            log.logError(this.toString(), Messages.getString("JobEntryFileCompare.ERROR_0005_File2_Does_Not_Exist", realFilename2), new Object[0]);
                        }
                        result.setResult(false);
                        result.setNrErrors(1L);
                    }
                    break block22;
                }
                log.logError(this.toString(), Messages.getString("JobEntryFileCompare.ERROR_0006_Need_Two_Filenames"), new Object[0]);
            }
            Object var13_13 = null;
            try {
                if (file1 != null) {
                    file1.close();
                }
                if (file2 != null) {
                    file2.close();
                }
                break block23;
            }
            catch (IOException e2) {}
            break block23;
            {
                catch (Exception e) {
                    result.setResult(false);
                    result.setNrErrors(1L);
                    log.logError(this.toString(), Messages.getString("JobEntryFileCompare.ERROR_0007_Comparing_Files", realFilename2, realFilename2, e.getMessage()), new Object[0]);
                    Object var13_14 = null;
                    try {
                        if (file1 != null) {
                            file1.close();
                        }
                        if (file2 != null) {
                            file2.close();
                        }
                        break block23;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    if (file1 != null) {
                        file1.close();
                    }
                    if (file2 != null) {
                        file2.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setFilename1(String filename) {
        this.filename1 = filename;
    }

    public String getFilename1() {
        return this.filename1;
    }

    public void setFilename2(String filename) {
        this.filename2 = filename;
    }

    public String getFilename2() {
        return this.filename2;
    }

    public boolean isAddFilenameToResult() {
        return this.addFilenameToResult;
    }

    public void setAddFilenameToResult(boolean addFilenameToResult) {
        this.addFilenameToResult = addFilenameToResult;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename1) && !Const.isEmpty((String)this.filename2)) {
            String realFilename1 = jobMeta.environmentSubstitute(this.filename1);
            String realFilename2 = jobMeta.environmentSubstitute(this.filename2);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFilename1, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realFilename2, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename1", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "filename2", remarks, ctx);
    }
}

