/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.datasource.descriptor;

import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.GeneralPropertiesProvider;
import org.graalvm.visualvm.core.model.ModelFactory;
import org.graalvm.visualvm.core.model.ModelProvider;
import org.graalvm.visualvm.core.properties.PropertiesSupport;

public final class DataSourceDescriptorFactory
extends ModelFactory<DataSourceDescriptor, DataSource>
implements ModelProvider<DataSourceDescriptor, DataSource> {
    private static DataSourceDescriptorFactory dsDescFactory;

    private DataSourceDescriptorFactory() {
    }

    public static synchronized DataSourceDescriptorFactory getDefault() {
        if (dsDescFactory == null) {
            dsDescFactory = new DataSourceDescriptorFactory();
            dsDescFactory.registerProvider(dsDescFactory);
            PropertiesSupport.sharedInstance().registerPropertiesProvider(new GeneralPropertiesProvider(), DataSource.class);
        }
        return dsDescFactory;
    }

    public static <X extends DataSource> DataSourceDescriptor<X> getDescriptor(X ds) {
        return (DataSourceDescriptor)DataSourceDescriptorFactory.getDefault().getModel(ds);
    }

    @Override
    public DataSourceDescriptor createModelFor(DataSource ds) {
        return new DefaultDataSourceDescriptor(ds);
    }

    private static class DefaultDataSourceDescriptor
    extends DataSourceDescriptor {
        DefaultDataSourceDescriptor(DataSource ds) {
            super(ds);
        }
    }
}

