/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.MacAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.PWDClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.PWDComputations;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDClientKeyExchangePreparator
extends ClientKeyExchangePreparator<PWDClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final PWDClientKeyExchangeMessage msg;

    public PWDClientKeyExchangePreparator(Chooser chooser, PWDClientKeyExchangeMessage msg) {
        super(chooser, msg);
        this.msg = msg;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing PWDClientKeyExchangeMessage");
        this.msg.prepareComputations();
        EllipticCurve curve = CurveFactory.getCurve(this.chooser.getSelectedNamedGroup());
        LOGGER.debug(this.chooser.getSelectedNamedGroup().getJavaName());
        try {
            this.preparePasswordElement(this.msg);
        }
        catch (CryptoException e) {
            throw new PreparationException("Failed to generate password element", e);
        }
        this.prepareScalarElement(this.msg);
        byte[] premasterSecret = this.generatePremasterSecret(this.msg.getComputations().getPasswordElement(), this.msg.getComputations().getPrivateKeyScalar(), curve);
        this.preparePremasterSecret(this.msg, premasterSecret);
        this.prepareClientServerRandom(this.msg);
    }

    @Override
    public void prepareAfterParse(boolean clientMode) {
        if (!clientMode) {
            this.msg.prepareComputations();
            EllipticCurve curve = CurveFactory.getCurve(this.chooser.getSelectedNamedGroup());
            byte[] premasterSecret = this.generatePremasterSecret(this.chooser.getContext().getPWDPE(), this.chooser.getContext().getServerPWDPrivate(), curve);
            this.preparePremasterSecret(this.msg, premasterSecret);
            this.prepareClientServerRandom(this.msg);
        }
    }

    protected void preparePasswordElement(PWDClientKeyExchangeMessage msg) throws CryptoException {
        EllipticCurve curve = CurveFactory.getCurve(this.chooser.getSelectedNamedGroup());
        Point passwordElement = PWDComputations.computePasswordElement(this.chooser, curve);
        msg.getComputations().setPasswordElement(passwordElement);
        LOGGER.debug("PasswordElement.x: " + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)passwordElement.getX().getData())));
    }

    protected MacAlgorithm getMacAlgorithm(CipherSuite suite) {
        if (suite.isSHA256()) {
            return MacAlgorithm.HMAC_SHA256;
        }
        if (suite.isSHA384()) {
            return MacAlgorithm.HMAC_SHA384;
        }
        if (suite.name().endsWith("SHA")) {
            return MacAlgorithm.HMAC_SHA1;
        }
        throw new PreparationException("Unsupported Mac Algorithm for suite " + suite.toString());
    }

    protected List<ECPointFormat> getPointFormatList() {
        List<ECPointFormat> sharedPointFormats = new ArrayList<ECPointFormat>(this.chooser.getClientSupportedPointFormats());
        if (sharedPointFormats.isEmpty()) {
            LOGGER.warn("Don't know which point format to use for PWD. Check if pointFormats is set in config.");
            sharedPointFormats = this.chooser.getConfig().getDefaultClientSupportedPointFormats();
        }
        ArrayList<ECPointFormat> unsupportedFormats = new ArrayList<ECPointFormat>();
        if (!this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            List<ECPointFormat> clientPointFormats = this.chooser.getClientSupportedPointFormats();
            for (ECPointFormat f : sharedPointFormats) {
                if (clientPointFormats.contains((Object)f)) continue;
                unsupportedFormats.add(f);
            }
        }
        sharedPointFormats.removeAll(unsupportedFormats);
        if (sharedPointFormats.isEmpty()) {
            sharedPointFormats = new ArrayList<ECPointFormat>(this.chooser.getConfig().getDefaultClientSupportedPointFormats());
        }
        return sharedPointFormats;
    }

    protected void prepareScalarElement(PWDClientKeyExchangeMessage msg) {
        EllipticCurve curve = CurveFactory.getCurve(this.chooser.getSelectedNamedGroup());
        PWDComputations.PWDKeyMaterial keyMaterial = PWDComputations.generateKeyMaterial(curve, msg.getComputations().getPasswordElement(), this.chooser);
        msg.getComputations().setPrivateKeyScalar(keyMaterial.privateKeyScalar);
        LOGGER.debug("Private: " + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)keyMaterial.privateKeyScalar)));
        this.prepareScalar(msg, keyMaterial.scalar);
        this.prepareScalarLength(msg);
        this.prepareElement(msg, keyMaterial.element);
        this.prepareElementLength(msg);
    }

    protected void prepareScalar(PWDClientKeyExchangeMessage msg, BigInteger scalar) {
        msg.setScalar(ArrayConverter.bigIntegerToByteArray((BigInteger)scalar));
        LOGGER.debug("Scalar: " + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)scalar)));
    }

    protected void prepareScalarLength(PWDClientKeyExchangeMessage msg) {
        msg.setScalarLength(((byte[])msg.getScalar().getValue()).length);
        LOGGER.debug("ScalarLength: " + msg.getScalarLength());
    }

    protected void prepareElement(PWDClientKeyExchangeMessage msg, Point element) {
        byte[] serializedElement = PointFormatter.formatToByteArray(this.chooser.getConfig().getDefaultSelectedNamedGroup(), element, this.chooser.getConfig().getDefaultSelectedPointFormat());
        msg.setElement(serializedElement);
        LOGGER.debug("Element: " + ArrayConverter.bytesToHexString((byte[])serializedElement));
    }

    protected void prepareElementLength(PWDClientKeyExchangeMessage msg) {
        msg.setElementLength(((byte[])msg.getElement().getValue()).length);
        LOGGER.debug("ElementLength: " + msg.getElementLength());
    }

    private byte[] generatePremasterSecret(Point passwordElement, BigInteger privateKeyScalar, EllipticCurve curve) {
        BigInteger peerScalar;
        Point peerElement;
        if (this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
            peerElement = this.chooser.getContext().getServerPWDElement();
            peerScalar = this.chooser.getContext().getServerPWDScalar();
        } else {
            peerElement = PointFormatter.formatFromByteArray(this.chooser.getSelectedNamedGroup(), (byte[])this.msg.getElement().getValue());
            peerScalar = new BigInteger(1, (byte[])this.msg.getScalar().getValue());
        }
        if (peerElement == null || peerScalar == null) {
            LOGGER.warn("Missing peer element or scalar, returning empty premaster secret");
            return new byte[0];
        }
        Point sharedSecret = curve.mult(privateKeyScalar, curve.add(curve.mult(peerScalar, passwordElement), peerElement));
        return ArrayConverter.bigIntegerToByteArray((BigInteger)sharedSecret.getX().getData());
    }

    private void preparePremasterSecret(PWDClientKeyExchangeMessage msg, byte[] premasterSecret) {
        msg.getComputations().setPremasterSecret(premasterSecret);
        LOGGER.debug("PremasterSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getComputations().getPremasterSecret().getValue())));
    }

    private void prepareClientServerRandom(PWDClientKeyExchangeMessage msg) {
        byte[] clientRandom = ArrayConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        msg.getComputations().setClientServerRandom(clientRandom);
        LOGGER.debug("ClientServerRandom: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getComputations().getClientServerRandom().getValue())));
    }
}

