/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.model.ReferenceType;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.OperationIO;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class PathItemIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<PathItem, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_PARAMETERS = "parameters";
    private static final String PROP_SERVERS = "servers";
    private static final String PROP_SUMMARY = "summary";
    private static final String PROP_OPERATIONS = "operations";

    public PathItemIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.PATH_ITEM, Names.create(PathItem.class));
    }

    @Override
    public PathItem read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@PathItem");
        PathItem pathItem = OASFactory.createPathItem();
        pathItem.setRef(ReferenceType.PATH_ITEM.refValue(annotation));
        pathItem.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        pathItem.setSummary((String)this.value(annotation, PROP_SUMMARY));
        pathItem.setServers(this.serverIO().readList(annotation.value(PROP_SERVERS)));
        pathItem.setParameters(this.parameterIO().readList(annotation.value(PROP_PARAMETERS)));
        Optional.ofNullable(annotation.value(PROP_OPERATIONS)).map(AnnotationValue::asNestedArray).ifPresent(annotations -> this.readOperationsInto(pathItem, (AnnotationInstance[])annotations, this.pathItemOperationIO()));
        pathItem.setExtensions(this.extensionIO().readExtensible(annotation));
        return pathItem;
    }

    public PathItem readCallbackOperations(AnnotationInstance[] annotations) {
        PathItem pathItem = OASFactory.createPathItem();
        this.readOperationsInto(pathItem, annotations, this.callbackOperationIO());
        return pathItem;
    }

    private void readOperationsInto(PathItem pathItem, AnnotationInstance[] annotations, OperationIO<V, A, O, AB, OB> operationIO) {
        Arrays.stream(annotations).filter(annotation -> Objects.nonNull(this.value((AnnotationInstance)annotation, "method"))).forEach(annotation -> {
            String method = (String)this.value((AnnotationInstance)annotation, "method");
            Operation operation = operationIO.read((AnnotationInstance)annotation);
            operation.setExtensions(this.extensionIO().readExtensible((AnnotationInstance)annotation));
            pathItem.setOperation(PathItem.HttpMethod.valueOf((String)method.toUpperCase(Locale.ROOT)), operation);
        });
    }
}

