/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.RepositoryMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RepositoriesMeta {
    private LogWriter log;
    private List<DatabaseMeta> databases;
    private List<RepositoryMeta> repositories;

    public RepositoriesMeta(LogWriter log) {
        this.log = log;
        this.clear();
    }

    public void clear() {
        this.databases = new ArrayList<DatabaseMeta>();
        this.repositories = new ArrayList<RepositoryMeta>();
    }

    public void addDatabase(DatabaseMeta ci) {
        this.databases.add(ci);
    }

    public void addRepository(RepositoryMeta ri) {
        this.repositories.add(ri);
    }

    public void addDatabase(int p, DatabaseMeta ci) {
        this.databases.add(p, ci);
    }

    public void addRepository(int p, RepositoryMeta ri) {
        this.repositories.add(p, ri);
    }

    public DatabaseMeta getDatabase(int i) {
        return this.databases.get(i);
    }

    public RepositoryMeta getRepository(int i) {
        return this.repositories.get(i);
    }

    public void removeDatabase(int i) {
        if (i < 0 || i >= this.databases.size()) {
            return;
        }
        this.databases.remove(i);
    }

    public void removeRepository(int i) {
        if (i < 0 || i >= this.repositories.size()) {
            return;
        }
        this.repositories.remove(i);
    }

    public int nrDatabases() {
        return this.databases.size();
    }

    public int nrRepositories() {
        return this.repositories.size();
    }

    public DatabaseMeta searchDatabase(String name) {
        for (int i = 0; i < this.nrDatabases(); ++i) {
            if (!this.getDatabase(i).getName().equalsIgnoreCase(name)) continue;
            return this.getDatabase(i);
        }
        return null;
    }

    public RepositoryMeta searchRepository(String name) {
        for (int i = 0; i < this.nrRepositories(); ++i) {
            String repName = this.getRepository(i).getName();
            if (repName == null || !repName.equalsIgnoreCase(name)) continue;
            return this.getRepository(i);
        }
        return null;
    }

    public int indexOfDatabase(DatabaseMeta di) {
        return this.databases.indexOf(di);
    }

    public int indexOfRepository(RepositoryMeta ri) {
        return this.repositories.indexOf(ri);
    }

    public RepositoryMeta findRepository(String name) {
        for (int i = 0; i < this.nrRepositories(); ++i) {
            RepositoryMeta ri = this.getRepository(i);
            if (!ri.getName().equalsIgnoreCase(name)) continue;
            return ri;
        }
        return null;
    }

    public boolean readData() {
        File file = new File(Const.getKettleLocalRepositoriesFile());
        if (!file.exists() || !file.isFile()) {
            this.log.logDetailed(this.toString(), "No repositories file found in the local directory: " + file.getAbsolutePath(), new Object[0]);
            file = new File(Const.getKettleUserRepositoriesFile());
        }
        this.log.logBasic(this.toString(), "Reading repositories XML file: " + file.getAbsoluteFile(), new Object[0]);
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            try {
                doc = db.parse(file);
            }
            catch (FileNotFoundException ef) {
                InputStream is = this.getClass().getResourceAsStream("/org/pentaho/di/repository/repositories.xml");
                if (is != null) {
                    doc = db.parse(is);
                }
                this.log.logError(this.toString(), "Error opening file: " + file.getAbsoluteFile() + " : " + ef.toString(), new Object[0]);
                return false;
            }
            this.clear();
            Node repsnode = XMLHandler.getSubNode((Node)doc, (String)"repositories");
            int nrconn = XMLHandler.countNodes((Node)repsnode, (String)"connection");
            this.log.logDebug(this.toString(), "We have " + nrconn + " connections...", new Object[0]);
            for (int i = 0; i < nrconn; ++i) {
                this.log.logDebug(this.toString(), "Looking at connection #" + i, new Object[0]);
                Node dbnode = XMLHandler.getSubNodeByNr((Node)repsnode, (String)"connection", (int)i);
                DatabaseMeta dbcon = new DatabaseMeta(dbnode);
                this.addDatabase(dbcon);
                this.log.logDebug(this.toString(), "Read connection : " + dbcon.getName(), new Object[0]);
            }
            int nrreps = XMLHandler.countNodes((Node)repsnode, (String)"repository");
            this.log.logDebug(this.toString(), "We have " + nrreps + " repositories...", new Object[0]);
            for (int i = 0; i < nrreps; ++i) {
                Node repnode = XMLHandler.getSubNodeByNr((Node)repsnode, (String)"repository", (int)i);
                this.log.logDebug(this.toString(), "Looking at repository #" + i, new Object[0]);
                RepositoryMeta repinfo = new RepositoryMeta();
                if (!repinfo.loadXML(repnode, this.databases)) continue;
                this.addRepository(repinfo);
                this.log.logDebug(this.toString(), "Read repository : " + repinfo.getName(), new Object[0]);
            }
        }
        catch (Exception e) {
            this.log.logError(this.toString(), "Error reading information from file : " + e.toString(), new Object[0]);
            this.log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
            this.clear();
            return false;
        }
        return true;
    }

    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + Const.CR;
        retval = retval + "<repositories>" + Const.CR;
        for (i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta conn = this.getDatabase(i);
            retval = retval + conn.getXML();
        }
        for (i = 0; i < this.nrRepositories(); ++i) {
            RepositoryMeta ri = this.getRepository(i);
            retval = retval + ri.getXML();
        }
        retval = retval + "  </repositories>" + Const.CR;
        return retval;
    }

    public boolean writeData() {
        try {
            FileOutputStream fos = new FileOutputStream(new File(Const.getKettleUserRepositoriesFile()));
            fos.write(this.getXML().getBytes());
            fos.close();
        }
        catch (FileNotFoundException e) {
            this.log.logError("Repository", "Writing repository we got error : " + e.toString(), new Object[0]);
            return false;
        }
        catch (IOException ie) {
            this.log.logError("Repository", "Writing repository we got IO error : " + ie.toString(), new Object[0]);
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

