/*	Public domain	*/

#ifndef _AGAR_GUI_PALETTES_H_
#define _AGAR_GUI_PALETTES_H_

/*
 * Standard palettes for Indexed modes <= 8 bpp.
 */

AG_Color agStdPalette1[2] = {                /* 1-bit palette */
#if AG_MODEL == AG_MEDIUM
	{ 0x00, 0x00, 0x00, 0xff },          /* black */
	{ 0xff, 0xff, 0xff, 0xff },          /* white */
#elif AG_MODEL == AG_LARGE
	{ 0x0000, 0x0000, 0x0000, 0xffff },  /* black */
	{ 0xffff, 0xffff, 0xffff, 0xffff },  /* white */
#endif
};

/*
 * 2-bit palette.
 */
AG_Color agStdPalette2[4] = {
#if AG_MODEL == AG_MEDIUM
	{ 0x00, 0x00, 0x00, 0xff },          /* black */
	{ 0x9b, 0x17, 0x08, 0xff },          /* dark red */
	{ 0x00, 0x90, 0x92, 0xff },          /* dark cyan */
	{ 0xff, 0xff, 0xff, 0xff },          /* white */
#elif AG_MODEL == AG_LARGE
	{ 0x0000, 0x0000, 0x0000, 0xffff },  /* black */
	{ 0x9b9b, 0x1717, 0x0808, 0xffff },  /* dark red */
	{ 0x0000, 0x9090, 0x9292, 0xffff },  /* dark cyan */
	{ 0xffff, 0xffff, 0xffff, 0xffff },  /* white */
#endif
};

/*
 * 4-bit palette (RGBI).
 */
AG_Color agStdPalette4[16] = {
#if AG_MODEL == AG_MEDIUM
	{ 0x00, 0x00, 0x00, 0xff },          /* black */
	{ 0x00, 0x12, 0x90, 0xff },          /* dark blue */
	{ 0x00, 0x8f, 0x15, 0xff },          /* dark green */
	{ 0x00, 0x90, 0x92, 0xff },          /* dark cyan */
	{ 0x9b, 0x17, 0x08, 0xff },          /* dark red */
	{ 0x9a, 0x20, 0x91, 0xff },          /* dark magenta */
	{ 0x94, 0x91, 0x19, 0xff },          /* dark yellow */
	{ 0xb8, 0xb8, 0xb8, 0xff },          /* light gray */
	{ 0x68, 0x68, 0x68, 0xff },          /* dark gray */
	{ 0x00, 0x27, 0xfb, 0xff },          /* blue */
	{ 0x00, 0xf9, 0x2c, 0xff },          /* green */
	{ 0x00, 0xfc, 0xfe, 0xff },          /* cyan */
	{ 0xff, 0x30, 0x16, 0xff },          /* red */
	{ 0xff, 0x3f, 0xfc, 0xff },          /* magenta */
	{ 0xff, 0xfd, 0x33, 0xff },          /* yellow */
	{ 0xff, 0xff, 0xff, 0xff },          /* white */
#elif AG_MODEL == AG_LARGE
	{ 0x0000, 0x0000, 0x0000, 0xffff },  /* black */
	{ 0x0000, 0x1212, 0x9090, 0xffff },  /* dark blue */
	{ 0x0000, 0x8f8f, 0x1515, 0xffff },  /* dark green */
	{ 0x0000, 0x9090, 0x9292, 0xffff },  /* dark cyan */
	{ 0x9b9b, 0x1717, 0x0808, 0xffff },  /* dark red */
	{ 0x9a9a, 0x2020, 0x9191, 0xffff },  /* dark magenta */
	{ 0x9494, 0x9191, 0x1919, 0xffff },  /* dark yellow */
	{ 0xb8b8, 0xb8b8, 0xb8b8, 0xffff },  /* light gray */
	{ 0x6868, 0x6868, 0x6868, 0xffff },  /* dark gray */
	{ 0x0000, 0x2727, 0xfbfb, 0xffff },  /* blue */
	{ 0x0000, 0xf9f9, 0x2c2c, 0xffff },  /* green */
	{ 0x0000, 0xfcfc, 0xfefe, 0xffff },  /* cyan */
	{ 0xffff, 0x3030, 0x1616, 0xffff },  /* red */
	{ 0xffff, 0x3f3f, 0xfcfc, 0xffff },  /* magenta */
	{ 0xffff, 0xfdfd, 0x3333, 0xffff },  /* yellow */
	{ 0xffff, 0xffff, 0xffff, 0xffff },  /* white */
#endif
};

/*
 * 8-bit palette (xterm-256-color).
 */
AG_Color agStdPalette8[256] = {
#if AG_MODEL == AG_MEDIUM
	{ 0x00, 0x00, 0x00, 0xff },         /* 000 */
	{ 0x80, 0x00, 0x00, 0xff },         /* 001 */
	{ 0x00, 0x80, 0x00, 0xff },         /* 002 */
	{ 0x80, 0x80, 0x00, 0xff },         /* 003 */
	{ 0x00, 0x00, 0x80, 0xff },         /* 004 */
	{ 0x80, 0x00, 0x80, 0xff },         /* 005 */
	{ 0x00, 0x80, 0x80, 0xff },         /* 006 */
	{ 0xc0, 0xc0, 0xc0, 0xff },         /* 007 */
	{ 0x80, 0x80, 0x80, 0xff },         /* 008 */
	{ 0xff, 0x00, 0x00, 0xff },         /* 009 */
	{ 0x00, 0xff, 0x00, 0xff },         /* 010 */
	{ 0xff, 0xff, 0x00, 0xff },         /* 011 */
	{ 0x00, 0x00, 0xff, 0xff },         /* 012 */
	{ 0xff, 0x00, 0xff, 0xff },         /* 013 */
	{ 0x00, 0xff, 0xff, 0xff },         /* 014 */
	{ 0xff, 0xff, 0xff, 0xff },         /* 015 */
	{ 0x00, 0x00, 0x00, 0xff },         /* 016 */
	{ 0x00, 0x00, 0x5f, 0xff },         /* 017 */
	{ 0x00, 0x00, 0x87, 0xff },         /* 018 */
	{ 0x00, 0x00, 0xaf, 0xff },         /* 019 */
	{ 0x00, 0x00, 0xd7, 0xff },         /* 020 */
	{ 0x00, 0x00, 0xff, 0xff },         /* 021 */
	{ 0x00, 0x5f, 0x00, 0xff },         /* 022 */
	{ 0x00, 0x5f, 0x5f, 0xff },         /* 023 */
	{ 0x00, 0x5f, 0x87, 0xff },         /* 024 */
	{ 0x00, 0x5f, 0xaf, 0xff },         /* 025 */
	{ 0x00, 0x5f, 0xd7, 0xff },         /* 026 */
	{ 0x00, 0x5f, 0xff, 0xff },         /* 027 */
	{ 0x00, 0x87, 0x00, 0xff },         /* 028 */
	{ 0x00, 0x87, 0x5f, 0xff },         /* 029 */
	{ 0x00, 0x87, 0x87, 0xff },         /* 030 */
	{ 0x00, 0x87, 0xaf, 0xff },         /* 031 */
	{ 0x00, 0x87, 0xd7, 0xff },         /* 032 */
	{ 0x00, 0x87, 0xff, 0xff },         /* 033 */
	{ 0x00, 0xaf, 0x00, 0xff },         /* 034 */
	{ 0x00, 0xaf, 0x5f, 0xff },         /* 035 */
	{ 0x00, 0xaf, 0x87, 0xff },         /* 036 */
	{ 0x00, 0xaf, 0xaf, 0xff },         /* 037 */
	{ 0x00, 0xaf, 0xd7, 0xff },         /* 038 */
	{ 0x00, 0xaf, 0xff, 0xff },         /* 039 */
	{ 0x00, 0xd7, 0x00, 0xff },         /* 040 */
	{ 0x00, 0xd7, 0x5f, 0xff },         /* 041 */
	{ 0x00, 0xd7, 0x87, 0xff },         /* 042 */
	{ 0x00, 0xd7, 0xaf, 0xff },         /* 043 */
	{ 0x00, 0xd7, 0xd7, 0xff },         /* 044 */
	{ 0x00, 0xd7, 0xff, 0xff },         /* 045 */
	{ 0x00, 0xff, 0x00, 0xff },         /* 046 */
	{ 0x00, 0xff, 0x5f, 0xff },         /* 047 */
	{ 0x00, 0xff, 0x87, 0xff },         /* 048 */
	{ 0x00, 0xff, 0xaf, 0xff },         /* 049 */
	{ 0x00, 0xff, 0xd7, 0xff },         /* 050 */
	{ 0x00, 0xff, 0xff, 0xff },         /* 051 */
	{ 0x5f, 0x00, 0x00, 0xff },         /* 052 */
	{ 0x5f, 0x00, 0x5f, 0xff },         /* 053 */
	{ 0x5f, 0x00, 0x87, 0xff },         /* 054 */
	{ 0x5f, 0x00, 0xaf, 0xff },         /* 055 */
	{ 0x5f, 0x00, 0xd7, 0xff },         /* 056 */
	{ 0x5f, 0x00, 0xff, 0xff },         /* 057 */
	{ 0x5f, 0x5f, 0x00, 0xff },         /* 058 */
	{ 0x5f, 0x5f, 0x5f, 0xff },         /* 059 */
	{ 0x5f, 0x5f, 0x87, 0xff },         /* 060 */
	{ 0x5f, 0x5f, 0xaf, 0xff },         /* 061 */
	{ 0x5f, 0x5f, 0xd7, 0xff },         /* 062 */
	{ 0x5f, 0x5f, 0xff, 0xff },         /* 063 */
	{ 0x5f, 0x87, 0x00, 0xff },         /* 064 */
	{ 0x5f, 0x87, 0x5f, 0xff },         /* 065 */
	{ 0x5f, 0x87, 0x87, 0xff },         /* 066 */
	{ 0x5f, 0x87, 0xaf, 0xff },         /* 067 */
	{ 0x5f, 0x87, 0xd7, 0xff },         /* 068 */
	{ 0x5f, 0x87, 0xff, 0xff },         /* 069 */
	{ 0x5f, 0xaf, 0x00, 0xff },         /* 070 */
	{ 0x5f, 0xaf, 0x5f, 0xff },         /* 071 */
	{ 0x5f, 0xaf, 0x87, 0xff },         /* 072 */
	{ 0x5f, 0xaf, 0xaf, 0xff },         /* 073 */
	{ 0x5f, 0xaf, 0xd7, 0xff },         /* 074 */
	{ 0x5f, 0xaf, 0xff, 0xff },         /* 075 */
	{ 0x5f, 0xd7, 0x00, 0xff },         /* 076 */
	{ 0x5f, 0xd7, 0x5f, 0xff },         /* 077 */
	{ 0x5f, 0xd7, 0x87, 0xff },         /* 078 */
	{ 0x5f, 0xd7, 0xaf, 0xff },         /* 079 */
	{ 0x5f, 0xd7, 0xd7, 0xff },         /* 080 */
	{ 0x5f, 0xd7, 0xff, 0xff },         /* 081 */
	{ 0x5f, 0xff, 0x00, 0xff },         /* 082 */
	{ 0x5f, 0xff, 0x5f, 0xff },         /* 083 */
	{ 0x5f, 0xff, 0x87, 0xff },         /* 084 */
	{ 0x5f, 0xff, 0xaf, 0xff },         /* 085 */
	{ 0x5f, 0xff, 0xd7, 0xff },         /* 086 */
	{ 0x5f, 0xff, 0xff, 0xff },         /* 087 */
	{ 0x87, 0x00, 0x00, 0xff },         /* 088 */
	{ 0x87, 0x00, 0x5f, 0xff },         /* 089 */
	{ 0x87, 0x00, 0x87, 0xff },         /* 090 */
	{ 0x87, 0x00, 0xaf, 0xff },         /* 091 */
	{ 0x87, 0x00, 0xd7, 0xff },         /* 092 */
	{ 0x87, 0x00, 0xff, 0xff },         /* 093 */
	{ 0x87, 0x5f, 0x00, 0xff },         /* 094 */
	{ 0x87, 0x5f, 0x5f, 0xff },         /* 095 */
	{ 0x87, 0x5f, 0x87, 0xff },         /* 096 */
	{ 0x87, 0x5f, 0xaf, 0xff },         /* 097 */
	{ 0x87, 0x5f, 0xd7, 0xff },         /* 098 */
	{ 0x87, 0x5f, 0xff, 0xff },         /* 099 */
	{ 0x87, 0x87, 0x00, 0xff },         /* 100 */
	{ 0x87, 0x87, 0x5f, 0xff },         /* 101 */
	{ 0x87, 0x87, 0x87, 0xff },         /* 102 */
	{ 0x87, 0x87, 0xaf, 0xff },         /* 103 */
	{ 0x87, 0x87, 0xd7, 0xff },         /* 104 */
	{ 0x87, 0x87, 0xff, 0xff },         /* 105 */
	{ 0x87, 0xaf, 0x00, 0xff },         /* 106 */
	{ 0x87, 0xaf, 0x5f, 0xff },         /* 107 */
	{ 0x87, 0xaf, 0x87, 0xff },         /* 108 */
	{ 0x87, 0xaf, 0xaf, 0xff },         /* 109 */
	{ 0x87, 0xaf, 0xd4, 0xff },         /* 110 */
	{ 0x87, 0xaf, 0xff, 0xff },         /* 111 */
	{ 0x87, 0xd7, 0x00, 0xff },         /* 112 */
	{ 0x87, 0xd7, 0x5f, 0xff },         /* 113 */
	{ 0x87, 0xd7, 0x87, 0xff },         /* 114 */
	{ 0x87, 0xd7, 0xaf, 0xff },         /* 115 */
	{ 0x87, 0xd7, 0xd7, 0xff },         /* 116 */
	{ 0x87, 0xd7, 0xff, 0xff },         /* 117 */
	{ 0x87, 0xff, 0x00, 0xff },         /* 118 */
	{ 0x87, 0xff, 0x5f, 0xff },         /* 119 */
	{ 0x87, 0xff, 0x87, 0xff },         /* 120 */
	{ 0x87, 0xff, 0xaf, 0xff },         /* 121 */
	{ 0x87, 0xff, 0xd7, 0xff },         /* 122 */
	{ 0x87, 0xff, 0xff, 0xff },         /* 123 */
	{ 0xaf, 0x00, 0x00, 0xff },         /* 124 */
	{ 0xaf, 0x00, 0x5f, 0xff },         /* 125 */
	{ 0xaf, 0x00, 0x87, 0xff },         /* 126 */
	{ 0xaf, 0x00, 0xaf, 0xff },         /* 127 */
	{ 0xaf, 0x00, 0xd7, 0xff },         /* 128 */
	{ 0xaf, 0x00, 0xff, 0xff },         /* 129 */
	{ 0xaf, 0x5f, 0x00, 0xff },         /* 130 */
	{ 0xaf, 0x5f, 0x5f, 0xff },         /* 131 */
	{ 0xaf, 0x5f, 0x87, 0xff },         /* 132 */
	{ 0xaf, 0x5f, 0xaf, 0xff },         /* 133 */
	{ 0xaf, 0x5f, 0xd7, 0xff },         /* 134 */
	{ 0xaf, 0x5f, 0xff, 0xff },         /* 135 */
	{ 0xaf, 0x87, 0x00, 0xff },         /* 136 */
	{ 0xaf, 0x87, 0x5f, 0xff },         /* 137 */
	{ 0xaf, 0x87, 0x87, 0xff },         /* 138 */
	{ 0xaf, 0x87, 0xaf, 0xff },         /* 139 */
	{ 0xaf, 0x87, 0xd7, 0xff },         /* 140 */
	{ 0xaf, 0x87, 0xff, 0xff },         /* 141 */
	{ 0xaf, 0xaf, 0x00, 0xff },         /* 142 */
	{ 0xaf, 0xaf, 0x5f, 0xff },         /* 143 */
	{ 0xaf, 0xaf, 0x87, 0xff },         /* 144 */
	{ 0xaf, 0xaf, 0xaf, 0xff },         /* 145 */
	{ 0xaf, 0xaf, 0xd7, 0xff },         /* 146 */
	{ 0xaf, 0xaf, 0xff, 0xff },         /* 147 */
	{ 0xaf, 0xd7, 0x00, 0xff },         /* 148 */
	{ 0xaf, 0xd7, 0x5f, 0xff },         /* 149 */
	{ 0xaf, 0xd7, 0x87, 0xff },         /* 150 */
	{ 0xaf, 0xd7, 0xaf, 0xff },         /* 151 */
	{ 0xaf, 0xd7, 0xd7, 0xff },         /* 152 */
	{ 0xaf, 0xd7, 0xff, 0xff },         /* 153 */
	{ 0xaf, 0xff, 0x00, 0xff },         /* 154 */
	{ 0xaf, 0xff, 0x5f, 0xff },         /* 155 */
	{ 0xaf, 0xff, 0x87, 0xff },         /* 156 */
	{ 0xaf, 0xff, 0xaf, 0xff },         /* 157 */
	{ 0xaf, 0xff, 0xd7, 0xff },         /* 158 */
	{ 0xaf, 0xff, 0xff, 0xff },         /* 159 */
	{ 0xd7, 0x00, 0x00, 0xff },         /* 160 */
	{ 0xd7, 0x00, 0x5f, 0xff },         /* 161 */
	{ 0xd7, 0x00, 0x87, 0xff },         /* 162 */
	{ 0xd7, 0x00, 0xaf, 0xff },         /* 163 */
	{ 0xd7, 0x00, 0xd7, 0xff },         /* 164 */
	{ 0xd7, 0x00, 0xff, 0xff },         /* 165 */
	{ 0xd7, 0x5f, 0x00, 0xff },         /* 166 */
	{ 0xd7, 0x5f, 0x5f, 0xff },         /* 167 */
	{ 0xd7, 0x5f, 0x87, 0xff },         /* 168 */
	{ 0xd7, 0x5f, 0xaf, 0xff },         /* 169 */
	{ 0xd7, 0x5f, 0xd7, 0xff },         /* 170 */
	{ 0xd7, 0x5f, 0xff, 0xff },         /* 171 */
	{ 0xd7, 0x87, 0x00, 0xff },         /* 172 */
	{ 0xd7, 0x87, 0x5f, 0xff },         /* 173 */
	{ 0xd7, 0x87, 0x87, 0xff },         /* 174 */
	{ 0xd7, 0x87, 0xaf, 0xff },         /* 175 */
	{ 0xd7, 0x87, 0xd7, 0xff },         /* 176 */
	{ 0xd7, 0x87, 0xff, 0xff },         /* 177 */
	{ 0xdf, 0xaf, 0x00, 0xff },         /* 178 */
	{ 0xdf, 0xaf, 0x5f, 0xff },         /* 179 */
	{ 0xdf, 0xaf, 0x87, 0xff },         /* 180 */
	{ 0xdf, 0xaf, 0xaf, 0xff },         /* 181 */
	{ 0xdf, 0xaf, 0xd7, 0xff },         /* 182 */
	{ 0xdf, 0xaf, 0xff, 0xff },         /* 183 */
	{ 0xdf, 0xdf, 0x00, 0xff },         /* 184 */
	{ 0xdf, 0xdf, 0x5f, 0xff },         /* 185 */
	{ 0xdf, 0xdf, 0x87, 0xff },         /* 186 */
	{ 0xdf, 0xdf, 0xaf, 0xff },         /* 187 */
	{ 0xdf, 0xdf, 0xd7, 0xff },         /* 188 */
	{ 0xdf, 0xdf, 0xff, 0xff },         /* 189 */
	{ 0xdf, 0xff, 0x00, 0xff },         /* 190 */
	{ 0xdf, 0xff, 0x5f, 0xff },         /* 191 */
	{ 0xdf, 0xff, 0x87, 0xff },         /* 192 */
	{ 0xdf, 0xff, 0xaf, 0xff },         /* 193 */
	{ 0xdf, 0xff, 0xdf, 0xff },         /* 194 */
	{ 0xdf, 0xff, 0xff, 0xff },         /* 195 */
	{ 0xff, 0x00, 0x00, 0xff },         /* 196 */
	{ 0xff, 0x00, 0x5f, 0xff },         /* 197 */
	{ 0xff, 0x00, 0x87, 0xff },         /* 198 */
	{ 0xff, 0x00, 0xaf, 0xff },         /* 199 */
	{ 0xff, 0x00, 0xdf, 0xff },         /* 200 */
	{ 0xff, 0x00, 0xff, 0xff },         /* 201 */
	{ 0xff, 0x5f, 0x00, 0xff },         /* 202 */
	{ 0xff, 0x5f, 0x5f, 0xff },         /* 203 */
	{ 0xff, 0x5f, 0x87, 0xff },         /* 204 */
	{ 0xff, 0x5f, 0xaf, 0xff },         /* 205 */
	{ 0xff, 0x5f, 0xdf, 0xff },         /* 206 */
	{ 0xff, 0x5f, 0xff, 0xff },         /* 207 */
	{ 0xff, 0x87, 0x00, 0xff },         /* 208 */
	{ 0xff, 0x87, 0x5f, 0xff },         /* 209 */
	{ 0xff, 0x87, 0x87, 0xff },         /* 210 */
	{ 0xff, 0x87, 0xaf, 0xff },         /* 211 */
	{ 0xff, 0x87, 0xdf, 0xff },         /* 212 */
	{ 0xff, 0x87, 0xff, 0xff },         /* 213 */
	{ 0xff, 0xaf, 0x00, 0xff },         /* 214 */
	{ 0xff, 0xaf, 0x5f, 0xff },         /* 215 */
	{ 0xff, 0xaf, 0x87, 0xff },         /* 216 */
	{ 0xff, 0xaf, 0xaf, 0xff },         /* 217 */
	{ 0xff, 0xaf, 0xdf, 0xff },         /* 218 */
	{ 0xff, 0xaf, 0xff, 0xff },         /* 219 */
	{ 0xff, 0xdf, 0x00, 0xff },         /* 220 */
	{ 0xff, 0xdf, 0x5f, 0xff },         /* 221 */
	{ 0xff, 0xdf, 0x87, 0xff },         /* 222 */
	{ 0xff, 0xdf, 0xaf, 0xff },         /* 223 */
	{ 0xff, 0xdf, 0xdf, 0xff },         /* 224 */
	{ 0xff, 0xdf, 0xff, 0xff },         /* 225 */
	{ 0xff, 0xff, 0x00, 0xff },         /* 226 */
	{ 0xff, 0xff, 0x5f, 0xff },         /* 227 */
	{ 0xff, 0xff, 0x87, 0xff },         /* 228 */
	{ 0xff, 0xff, 0xaf, 0xff },         /* 229 */
	{ 0xff, 0xff, 0xdf, 0xff },         /* 230 */
	{ 0xff, 0xff, 0xff, 0xff },         /* 231 */
	{ 0x08, 0x08, 0x08, 0xff },         /* 232 */
	{ 0x12, 0x12, 0x12, 0xff },         /* 233 */
	{ 0x1c, 0x1c, 0x1c, 0xff },         /* 234 */
	{ 0x26, 0x26, 0x26, 0xff },         /* 235 */
	{ 0x30, 0x30, 0x30, 0xff },         /* 236 */
	{ 0x3a, 0x3a, 0x3a, 0xff },         /* 237 */
	{ 0x44, 0x44, 0x44, 0xff },         /* 238 */
	{ 0x4e, 0x4e, 0x4e, 0xff },         /* 239 */
	{ 0x58, 0x58, 0x58, 0xff },         /* 240 */
	{ 0x62, 0x62, 0x62, 0xff },         /* 241 */
	{ 0x6c, 0x6c, 0x6c, 0xff },         /* 242 */
	{ 0x76, 0x76, 0x76, 0xff },         /* 243 */
	{ 0x80, 0x80, 0x80, 0xff },         /* 244 */
	{ 0x8a, 0x8a, 0x8a, 0xff },         /* 245 */
	{ 0x94, 0x94, 0x94, 0xff },         /* 246 */
	{ 0x9e, 0x9e, 0x9e, 0xff },         /* 247 */
	{ 0xa8, 0xa8, 0xa8, 0xff },         /* 248 */
	{ 0xb2, 0xb2, 0xb2, 0xff },         /* 249 */
	{ 0xbc, 0xbc, 0xbc, 0xff },         /* 250 */
	{ 0xc6, 0xc6, 0xc6, 0xff },         /* 251 */
	{ 0xd0, 0xd0, 0xd0, 0xff },         /* 252 */
	{ 0xda, 0xda, 0xda, 0xff },         /* 253 */
	{ 0xe4, 0xe4, 0xe4, 0xff },         /* 254 */
	{ 0xee, 0xee, 0xee, 0xff }          /* 255 */
#elif AG_MODEL == AG_LARGE
	{ 0x0000, 0x0000, 0x0000, 0xffff }, /* 000 */
	{ 0x8080, 0x0000, 0x0000, 0xffff }, /* 001 */
	{ 0x0000, 0x8080, 0x0000, 0xffff }, /* 002 */
	{ 0x8080, 0x8080, 0x0000, 0xffff }, /* 003 */
	{ 0x0000, 0x0000, 0x8080, 0xffff }, /* 004 */
	{ 0x8080, 0x0000, 0x8080, 0xffff }, /* 005 */
	{ 0x0000, 0x8080, 0x8080, 0xffff }, /* 006 */
	{ 0xc0c0, 0xc0c0, 0xc0c0, 0xffff }, /* 007 */
	{ 0x8080, 0x8080, 0x8080, 0xffff }, /* 008 */
	{ 0xffff, 0x0000, 0x0000, 0xffff }, /* 009 */
	{ 0x0000, 0xffff, 0x0000, 0xffff }, /* 010 */
	{ 0xffff, 0xffff, 0x0000, 0xffff }, /* 011 */
	{ 0x0000, 0x0000, 0xffff, 0xffff }, /* 012 */
	{ 0xffff, 0x0000, 0xffff, 0xffff }, /* 013 */
	{ 0x0000, 0xffff, 0xffff, 0xffff }, /* 014 */
	{ 0xffff, 0xffff, 0xffff, 0xffff }, /* 015 */
	{ 0x0000, 0x0000, 0x0000, 0xffff }, /* 016 */
	{ 0x0000, 0x0000, 0x5f5f, 0xffff }, /* 017 */
	{ 0x0000, 0x0000, 0x8787, 0xffff }, /* 018 */
	{ 0x0000, 0x0000, 0xafaf, 0xffff }, /* 019 */
	{ 0x0000, 0x0000, 0xd7d7, 0xffff }, /* 020 */
	{ 0x0000, 0x0000, 0xffff, 0xffff }, /* 021 */
	{ 0x0000, 0x5f5f, 0x0000, 0xffff }, /* 022 */
	{ 0x0000, 0x5f5f, 0x5f5f, 0xffff }, /* 023 */
	{ 0x0000, 0x5f5f, 0x8787, 0xffff }, /* 024 */
	{ 0x0000, 0x5f5f, 0xafaf, 0xffff }, /* 025 */
	{ 0x0000, 0x5f5f, 0xd7d7, 0xffff }, /* 026 */
	{ 0x0000, 0x5f5f, 0xffff, 0xffff }, /* 027 */
	{ 0x0000, 0x8787, 0x0000, 0xffff }, /* 028 */
	{ 0x0000, 0x8787, 0x5f5f, 0xffff }, /* 029 */
	{ 0x0000, 0x8787, 0x8787, 0xffff }, /* 030 */
	{ 0x0000, 0x8787, 0xafaf, 0xffff }, /* 031 */
	{ 0x0000, 0x8787, 0xd7d7, 0xffff }, /* 032 */
	{ 0x0000, 0x8787, 0xffff, 0xffff }, /* 033 */
	{ 0x0000, 0xafaf, 0x0000, 0xffff }, /* 034 */
	{ 0x0000, 0xafaf, 0x5f5f, 0xffff }, /* 035 */
	{ 0x0000, 0xafaf, 0x8787, 0xffff }, /* 036 */
	{ 0x0000, 0xafaf, 0xafaf, 0xffff }, /* 037 */
	{ 0x0000, 0xafaf, 0xd7d7, 0xffff }, /* 038 */
	{ 0x0000, 0xafaf, 0xffff, 0xffff }, /* 039 */
	{ 0x0000, 0xd7d7, 0x0000, 0xffff }, /* 040 */
	{ 0x0000, 0xd7d7, 0x5f5f, 0xffff }, /* 041 */
	{ 0x0000, 0xd7d7, 0x8787, 0xffff }, /* 042 */
	{ 0x0000, 0xd7d7, 0xafaf, 0xffff }, /* 043 */
	{ 0x0000, 0xd7d7, 0xd7d7, 0xffff }, /* 044 */
	{ 0x0000, 0xd7d7, 0xffff, 0xffff }, /* 045 */
	{ 0x0000, 0xffff, 0x0000, 0xffff }, /* 046 */
	{ 0x0000, 0xffff, 0x5f5f, 0xffff }, /* 047 */
	{ 0x0000, 0xffff, 0x8787, 0xffff }, /* 048 */
	{ 0x0000, 0xffff, 0xafaf, 0xffff }, /* 049 */
	{ 0x0000, 0xffff, 0xd7d7, 0xffff }, /* 050 */
	{ 0x0000, 0xffff, 0xffff, 0xffff }, /* 051 */
	{ 0x5f5f, 0x0000, 0x0000, 0xffff }, /* 052 */
	{ 0x5f5f, 0x0000, 0x5f5f, 0xffff }, /* 053 */
	{ 0x5f5f, 0x0000, 0x8787, 0xffff }, /* 054 */
	{ 0x5f5f, 0x0000, 0xafaf, 0xffff }, /* 055 */
	{ 0x5f5f, 0x0000, 0xd7d7, 0xffff }, /* 056 */
	{ 0x5f5f, 0x0000, 0xffff, 0xffff }, /* 057 */
	{ 0x5f5f, 0x5f5f, 0x0000, 0xffff }, /* 058 */
	{ 0x5f5f, 0x5f5f, 0x5f5f, 0xffff }, /* 059 */
	{ 0x5f5f, 0x5f5f, 0x8787, 0xffff }, /* 060 */
	{ 0x5f5f, 0x5f5f, 0xafaf, 0xffff }, /* 061 */
	{ 0x5f5f, 0x5f5f, 0xd7d7, 0xffff }, /* 062 */
	{ 0x5f5f, 0x5f5f, 0xffff, 0xffff }, /* 063 */
	{ 0x5f5f, 0x8787, 0x0000, 0xffff }, /* 064 */
	{ 0x5f5f, 0x8787, 0x5f5f, 0xffff }, /* 065 */
	{ 0x5f5f, 0x8787, 0x8787, 0xffff }, /* 066 */
	{ 0x5f5f, 0x8787, 0xafaf, 0xffff }, /* 067 */
	{ 0x5f5f, 0x8787, 0xd7d7, 0xffff }, /* 068 */
	{ 0x5f5f, 0x8787, 0xffff, 0xffff }, /* 069 */
	{ 0x5f5f, 0xafaf, 0x0000, 0xffff }, /* 070 */
	{ 0x5f5f, 0xafaf, 0x5f5f, 0xffff }, /* 071 */
	{ 0x5f5f, 0xafaf, 0x8787, 0xffff }, /* 072 */
	{ 0x5f5f, 0xafaf, 0xafaf, 0xffff }, /* 073 */
	{ 0x5f5f, 0xafaf, 0xd7d7, 0xffff }, /* 074 */
	{ 0x5f5f, 0xafaf, 0xffff, 0xffff }, /* 075 */
	{ 0x5f5f, 0xd7d7, 0x0000, 0xffff }, /* 076 */
	{ 0x5f5f, 0xd7d7, 0x5f5f, 0xffff }, /* 077 */
	{ 0x5f5f, 0xd7d7, 0x8787, 0xffff }, /* 078 */
	{ 0x5f5f, 0xd7d7, 0xafaf, 0xffff }, /* 079 */
	{ 0x5f5f, 0xd7d7, 0xd7d7, 0xffff }, /* 080 */
	{ 0x5f5f, 0xd7d7, 0xffff, 0xffff }, /* 081 */
	{ 0x5f5f, 0xffff, 0x0000, 0xffff }, /* 082 */
	{ 0x5f5f, 0xffff, 0x5f5f, 0xffff }, /* 083 */
	{ 0x5f5f, 0xffff, 0x8787, 0xffff }, /* 084 */
	{ 0x5f5f, 0xffff, 0xafaf, 0xffff }, /* 085 */
	{ 0x5f5f, 0xffff, 0xd7d7, 0xffff }, /* 086 */
	{ 0x5f5f, 0xffff, 0xffff, 0xffff }, /* 087 */
	{ 0x8787, 0x0000, 0x0000, 0xffff }, /* 088 */
	{ 0x8787, 0x0000, 0x5f5f, 0xffff }, /* 089 */
	{ 0x8787, 0x0000, 0x8787, 0xffff }, /* 090 */
	{ 0x8787, 0x0000, 0xafaf, 0xffff }, /* 091 */
	{ 0x8787, 0x0000, 0xd7d7, 0xffff }, /* 092 */
	{ 0x8787, 0x0000, 0xffff, 0xffff }, /* 093 */
	{ 0x8787, 0x5f5f, 0x0000, 0xffff }, /* 094 */
	{ 0x8787, 0x5f5f, 0x5f5f, 0xffff }, /* 095 */
	{ 0x8787, 0x5f5f, 0x8787, 0xffff }, /* 096 */
	{ 0x8787, 0x5f5f, 0xafaf, 0xffff }, /* 097 */
	{ 0x8787, 0x5f5f, 0xd7d7, 0xffff }, /* 098 */
	{ 0x8787, 0x5f5f, 0xffff, 0xffff }, /* 099 */
	{ 0x8787, 0x8787, 0x0000, 0xffff }, /* 100 */
	{ 0x8787, 0x8787, 0x5f5f, 0xffff }, /* 101 */
	{ 0x8787, 0x8787, 0x8787, 0xffff }, /* 102 */
	{ 0x8787, 0x8787, 0xafaf, 0xffff }, /* 103 */
	{ 0x8787, 0x8787, 0xd7d7, 0xffff }, /* 104 */
	{ 0x8787, 0x8787, 0xffff, 0xffff }, /* 105 */
	{ 0x8787, 0xafaf, 0x0000, 0xffff }, /* 106 */
	{ 0x8787, 0xafaf, 0x5f5f, 0xffff }, /* 107 */
	{ 0x8787, 0xafaf, 0x8787, 0xffff }, /* 108 */
	{ 0x8787, 0xafaf, 0xafaf, 0xffff }, /* 109 */
	{ 0x8787, 0xafaf, 0xd7d7, 0xffff }, /* 110 */
	{ 0x8787, 0xafaf, 0xffff, 0xffff }, /* 111 */
	{ 0x8787, 0xd7d7, 0x0000, 0xffff }, /* 112 */
	{ 0x8787, 0xd7d7, 0x5f5f, 0xffff }, /* 113 */
	{ 0x8787, 0xd7d7, 0x8787, 0xffff }, /* 114 */
	{ 0x8787, 0xd7d7, 0xafaf, 0xffff }, /* 115 */
	{ 0x8787, 0xd7d7, 0xd7d7, 0xffff }, /* 116 */
	{ 0x8787, 0xd7d7, 0xffff, 0xffff }, /* 117 */
	{ 0x8787, 0xffff, 0x0000, 0xffff }, /* 118 */
	{ 0x8787, 0xffff, 0x5f5f, 0xffff }, /* 119 */
	{ 0x8787, 0xffff, 0x8787, 0xffff }, /* 120 */
	{ 0x8787, 0xffff, 0xafaf, 0xffff }, /* 121 */
	{ 0x8787, 0xffff, 0xd7d7, 0xffff }, /* 122 */
	{ 0x8787, 0xffff, 0xffff, 0xffff }, /* 123 */
	{ 0xafaf, 0x0000, 0x0000, 0xffff }, /* 124 */
	{ 0xafaf, 0x0000, 0x5f5f, 0xffff }, /* 125 */
	{ 0xafaf, 0x0000, 0x8787, 0xffff }, /* 126 */
	{ 0xafaf, 0x0000, 0xafaf, 0xffff }, /* 127 */
	{ 0xafaf, 0x0000, 0xd7d7, 0xffff }, /* 128 */
	{ 0xafaf, 0x0000, 0xffff, 0xffff }, /* 129 */
	{ 0xafaf, 0x5f5f, 0x0000, 0xffff }, /* 130 */
	{ 0xafaf, 0x5f5f, 0x5f5f, 0xffff }, /* 131 */
	{ 0xafaf, 0x5f5f, 0x8787, 0xffff }, /* 132 */
	{ 0xafaf, 0x5f5f, 0xafaf, 0xffff }, /* 133 */
	{ 0xafaf, 0x5f5f, 0xd7d7, 0xffff }, /* 134 */
	{ 0xafaf, 0x5f5f, 0xffff, 0xffff }, /* 135 */
	{ 0xafaf, 0x8787, 0x0000, 0xffff }, /* 136 */
	{ 0xafaf, 0x8787, 0x5f5f, 0xffff }, /* 137 */
	{ 0xafaf, 0x8787, 0x8787, 0xffff }, /* 138 */
	{ 0xafaf, 0x8787, 0xafaf, 0xffff }, /* 139 */
	{ 0xafaf, 0x8787, 0xd7d7, 0xffff }, /* 140 */
	{ 0xafaf, 0x8787, 0xffff, 0xffff }, /* 141 */
	{ 0xafaf, 0xafaf, 0x0000, 0xffff }, /* 142 */
	{ 0xafaf, 0xafaf, 0x5f5f, 0xffff }, /* 143 */
	{ 0xafaf, 0xafaf, 0x8787, 0xffff }, /* 144 */
	{ 0xafaf, 0xafaf, 0xafaf, 0xffff }, /* 145 */
	{ 0xafaf, 0xafaf, 0xd7d7, 0xffff }, /* 146 */
	{ 0xafaf, 0xafaf, 0xffff, 0xffff }, /* 147 */
	{ 0xafaf, 0xd7d7, 0x0000, 0xffff }, /* 148 */
	{ 0xafaf, 0xd7d7, 0x5f5f, 0xffff }, /* 149 */
	{ 0xafaf, 0xd7d7, 0x8787, 0xffff }, /* 150 */
	{ 0xafaf, 0xd7d7, 0xafaf, 0xffff }, /* 151 */
	{ 0xafaf, 0xd7d7, 0xd7d7, 0xffff }, /* 152 */
	{ 0xafaf, 0xd7d7, 0xffff, 0xffff }, /* 153 */
	{ 0xafaf, 0xffff, 0x0000, 0xffff }, /* 154 */
	{ 0xafaf, 0xffff, 0x5f5f, 0xffff }, /* 155 */
	{ 0xafaf, 0xffff, 0x8787, 0xffff }, /* 156 */
	{ 0xafaf, 0xffff, 0xafaf, 0xffff }, /* 157 */
	{ 0xafaf, 0xffff, 0xd7d7, 0xffff }, /* 158 */
	{ 0xafaf, 0xffff, 0xffff, 0xffff }, /* 159 */
	{ 0xd7d7, 0x0000, 0x0000, 0xffff }, /* 160 */
	{ 0xd7d7, 0x0000, 0x5f5f, 0xffff }, /* 161 */
	{ 0xd7d7, 0x0000, 0x8787, 0xffff }, /* 162 */
	{ 0xd7d7, 0x0000, 0xafaf, 0xffff }, /* 163 */
	{ 0xd7d7, 0x0000, 0xd7d7, 0xffff }, /* 164 */
	{ 0xd7d7, 0x0000, 0xffff, 0xffff }, /* 165 */
	{ 0xd7d7, 0x5f5f, 0x0000, 0xffff }, /* 166 */
	{ 0xd7d7, 0x5f5f, 0x5f5f, 0xffff }, /* 167 */
	{ 0xd7d7, 0x5f5f, 0x8787, 0xffff }, /* 168 */
	{ 0xd7d7, 0x5f5f, 0xafaf, 0xffff }, /* 169 */
	{ 0xd7d7, 0x5f5f, 0xd7d7, 0xffff }, /* 170 */
	{ 0xd7d7, 0x5f5f, 0xffff, 0xffff }, /* 171 */
	{ 0xd7d7, 0x8787, 0x0000, 0xffff }, /* 172 */
	{ 0xd7d7, 0x8787, 0x5f5f, 0xffff }, /* 173 */
	{ 0xd7d7, 0x8787, 0x8787, 0xffff }, /* 174 */
	{ 0xd7d7, 0x8787, 0xafaf, 0xffff }, /* 175 */
	{ 0xd7d7, 0x8787, 0xd7d7, 0xffff }, /* 176 */
	{ 0xd7d7, 0x8787, 0xffff, 0xffff }, /* 177 */
	{ 0xdfdf, 0xafaf, 0x0000, 0xffff }, /* 178 */
	{ 0xdfdf, 0xafaf, 0x5f5f, 0xffff }, /* 179 */
	{ 0xdfdf, 0xafaf, 0x8787, 0xffff }, /* 180 */
	{ 0xdfdf, 0xafaf, 0xafaf, 0xffff }, /* 181 */
	{ 0xdfdf, 0xafaf, 0xd7d7, 0xffff }, /* 182 */
	{ 0xdfdf, 0xafaf, 0xffff, 0xffff }, /* 183 */
	{ 0xdfdf, 0xdfdf, 0x0000, 0xffff }, /* 184 */
	{ 0xdfdf, 0xdfdf, 0x5f5f, 0xffff }, /* 185 */
	{ 0xdfdf, 0xdfdf, 0x8787, 0xffff }, /* 186 */
	{ 0xdfdf, 0xdfdf, 0xafaf, 0xffff }, /* 187 */
	{ 0xdfdf, 0xdfdf, 0xd7d7, 0xffff }, /* 188 */
	{ 0xdfdf, 0xdfdf, 0xffff, 0xffff }, /* 189 */
	{ 0xdfdf, 0xffff, 0x0000, 0xffff }, /* 190 */
	{ 0xdfdf, 0xffff, 0x5f5f, 0xffff }, /* 191 */
	{ 0xdfdf, 0xffff, 0x8787, 0xffff }, /* 192 */
	{ 0xdfdf, 0xffff, 0xafaf, 0xffff }, /* 193 */
	{ 0xdfdf, 0xffff, 0xdfdf, 0xffff }, /* 194 */
	{ 0xdfdf, 0xffff, 0xffff, 0xffff }, /* 195 */
	{ 0xffff, 0x0000, 0x0000, 0xffff }, /* 196 */
	{ 0xffff, 0x0000, 0x5f5f, 0xffff }, /* 197 */
	{ 0xffff, 0x0000, 0x8787, 0xffff }, /* 198 */
	{ 0xffff, 0x0000, 0xafaf, 0xffff }, /* 199 */
	{ 0xffff, 0x0000, 0xdfdf, 0xffff }, /* 200 */
	{ 0xffff, 0x0000, 0xffff, 0xffff }, /* 201 */
	{ 0xffff, 0x5f5f, 0x0000, 0xffff }, /* 202 */
	{ 0xffff, 0x5f5f, 0x5f5f, 0xffff }, /* 203 */
	{ 0xffff, 0x5f5f, 0x8787, 0xffff }, /* 204 */
	{ 0xffff, 0x5f5f, 0xafaf, 0xffff }, /* 205 */
	{ 0xffff, 0x5f5f, 0xdfdf, 0xffff }, /* 206 */
	{ 0xffff, 0x5f5f, 0xffff, 0xffff }, /* 207 */
	{ 0xffff, 0x8787, 0x0000, 0xffff }, /* 208 */
	{ 0xffff, 0x8787, 0x5f5f, 0xffff }, /* 209 */
	{ 0xffff, 0x8787, 0x8787, 0xffff }, /* 210 */
	{ 0xffff, 0x8787, 0xafaf, 0xffff }, /* 211 */
	{ 0xffff, 0x8787, 0xdfdf, 0xffff }, /* 212 */
	{ 0xffff, 0x8787, 0xffff, 0xffff }, /* 213 */
	{ 0xffff, 0xafaf, 0x0000, 0xffff }, /* 214 */
	{ 0xffff, 0xafaf, 0x5f5f, 0xffff }, /* 215 */
	{ 0xffff, 0xafaf, 0x8787, 0xffff }, /* 216 */
	{ 0xffff, 0xafaf, 0xafaf, 0xffff }, /* 217 */
	{ 0xffff, 0xafaf, 0xdfdf, 0xffff }, /* 218 */
	{ 0xffff, 0xafaf, 0xffff, 0xffff }, /* 219 */
	{ 0xffff, 0xdfdf, 0x0000, 0xffff }, /* 220 */
	{ 0xffff, 0xdfdf, 0x5f5f, 0xffff }, /* 221 */
	{ 0xffff, 0xdfdf, 0x8787, 0xffff }, /* 222 */
	{ 0xffff, 0xdfdf, 0xafaf, 0xffff }, /* 223 */
	{ 0xffff, 0xdfdf, 0xdfdf, 0xffff }, /* 224 */
	{ 0xffff, 0xdfdf, 0xffff, 0xffff }, /* 225 */
	{ 0xffff, 0xffff, 0x0000, 0xffff }, /* 226 */
	{ 0xffff, 0xffff, 0x5f5f, 0xffff }, /* 227 */
	{ 0xffff, 0xffff, 0x8787, 0xffff }, /* 228 */
	{ 0xffff, 0xffff, 0xafaf, 0xffff }, /* 229 */
	{ 0xffff, 0xffff, 0xdfdf, 0xffff }, /* 230 */
	{ 0xffff, 0xffff, 0xffff, 0xffff }, /* 231 */
	{ 0x0808, 0x0808, 0x0808, 0xffff }, /* 232 */
	{ 0x1212, 0x1212, 0x1212, 0xffff }, /* 233 */
	{ 0x1c1c, 0x1c1c, 0x1c1c, 0xffff }, /* 234 */
	{ 0x2626, 0x2626, 0x2626, 0xffff }, /* 235 */
	{ 0x3030, 0x3030, 0x3030, 0xffff }, /* 236 */
	{ 0x3a3a, 0x3a3a, 0x3a3a, 0xffff }, /* 237 */
	{ 0x4444, 0x4444, 0x4444, 0xffff }, /* 238 */
	{ 0x4e4e, 0x4e4e, 0x4e4e, 0xffff }, /* 239 */
	{ 0x5858, 0x5858, 0x5858, 0xffff }, /* 240 */
	{ 0x6262, 0x6262, 0x6262, 0xffff }, /* 241 */
	{ 0x6c6c, 0x6c6c, 0x6c6c, 0xffff }, /* 242 */
	{ 0x7676, 0x7676, 0x7676, 0xffff }, /* 243 */
	{ 0x8080, 0x8080, 0x8080, 0xffff }, /* 244 */
	{ 0x8a8a, 0x8a8a, 0x8a8a, 0xffff }, /* 245 */
	{ 0x9494, 0x9494, 0x9494, 0xffff }, /* 246 */
	{ 0x9e9e, 0x9e9e, 0x9e9e, 0xffff }, /* 247 */
	{ 0xa8a8, 0xa8a8, 0xa8a8, 0xffff }, /* 248 */
	{ 0xb2b2, 0xb2b2, 0xb2b2, 0xffff }, /* 249 */
	{ 0xbcbc, 0xbcbc, 0xbcbc, 0xffff }, /* 250 */
	{ 0xc6c6, 0xc6c6, 0xc6c6, 0xffff }, /* 251 */
	{ 0xd0d0, 0xd0d0, 0xd0d0, 0xffff }, /* 252 */
	{ 0xdada, 0xdada, 0xdada, 0xffff }, /* 253 */
	{ 0xe4e4, 0xe4e4, 0xe4e4, 0xffff }, /* 254 */
	{ 0xeeee, 0xeeee, 0xeeee, 0xffff }  /* 255 */
#endif /* AG_MODEL */
};

AG_Color *agStdPalette[8] = {
	agStdPalette1,
	agStdPalette2,
	NULL,          /* 3-bit */
	agStdPalette4,
	NULL,          /* 5-bit */
	NULL,          /* 6-bit */
	NULL,          /* 7-bit */
	agStdPalette8
};

#endif /* _AGAR_GUI_PALETTES_H_ */
