/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sign(ivec2(-5, -2)) => ivec2(-1, -1)
 * sign(ivec2(-1, 0)) => ivec2(-1, 0)
 * sign(ivec2(1, 2)) => ivec2(1, 1)
 * sign(ivec2(5, -5)) => ivec2(1, -1)
 */
#version 130

void main()
{
  float[all(equal(sign(ivec2(-5, -2)), ivec2(-1, -1))) ? 1 : -1] array0;
  float[all(equal(sign(ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array1;
  float[all(equal(sign(ivec2(1, 2)), ivec2(1, 1))) ? 1 : -1] array2;
  float[all(equal(sign(ivec2(5, -5)), ivec2(1, -1))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
