# Contributing

We love pull requests. Here's a quick guide:

1. Fork the repo.

1. Create your feature branch (`git checkout -b my-new-feature`)

1. Update CHANGELOG.md with a brief description of your changes under the `unreleased` heading.

1. Add/Update tests were appropriate

1. Commit your changes (`git commit -am 'Added some feature'`)

1. Push to the branch (`git push origin my-new-feature`)

1. Create new Pull Request

At this point you're waiting on us. We are not super fast at responding, but we will do our best to get to your PR as soon as time permits. We may suggest some changes, improvements or alternatives.

Some things that will increase the chance that your pull request is accepted is to follow the practices described on [Ruby style guide](https://github.com/bbatsov/ruby-style-guide), [Rails style guide](https://github.com/bbatsov/rails-style-guide) and [Better Specs](http://betterspecs.org/).

## Specs

To run all the specs in all gemfiles just run:

```
$ rake
```

To run specs of a single gemfile run:

```
$ appraisal rails-3.2 rake
```

If you want to run a specific spec in a gemfile run:

```
$ appraisal rails-3.2 rspec spec/colors_spec.rb
```

## Contributor Rolecall

Special thanks goes to amazing team of contributors, namely:

* 6fusion.com -- https://github.com/6fusion
* Adam Doppelt -- https://github.com/gurgeous
* Andrew O'Brien -- https://github.com/AndrewO
* Andrew Horsman -- https://github.com/basicxman
* Barry Allard -- https://github.com/steakknife
* Benoit Daloze -- http://github.com/eregon
* Brandon Zylstra -- https://github.com/brandondrew
* Dan Lynn -- https://github.com/danlynn
* Daniel Johnson -- https://github.com/adhd360
* Daniel Bretoi -- http://github.com/danielb2
* Eloy Duran -- http://github.com/alloy
* Elpizo Choi -- https://github.com/fuJiin
* Evan Senter -- https://github.com/evansenter
* George . -- https://github.com/gardelea
* Greg Weber -- https://github.com/gregwebs
* Jan Vansteenkiste -- https://github.com/vStone
* Jeff Felchner -- https://github.com/jfelchner
* Jonathan Davies -- send your Github URL ;-)
* Kevin Olbrich -- https://github.com/olbrich
* Matthew Schulkind -- https://github.com/mschulkind
* Mike McQuaid -- https://github.com/mikemcquaid
* Nami-Doc -- https://github.com/Nami-Doc
* Nicolas Viennot -- https://github.com/nviennot
* Nikolaj Nikolajsen -- https://github.com/nikolajsen
* Richard Hall -- https://github.com/richardardrichard
* Ryan Schlesinger -- https://github.com/ryansch
* Scott Hyndman -- https://github.com/shyndman
* Sean Gallagher -- http://github.com/torandu
* Stephan Hagemann -- https://github.com/shageman
* Tim Harper -- http://github.com/timcharper
* Tobias Crawley -- http://github.com/tobias
* Thibaut Barrère -- https://github.com/thbar
* Trevor Wennblom -- https://github.com/trevor
* vfrride -- https://github.com/vfrride
* Viktar Basharymau -- https://github.com/DNNX
