/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.ITokenProvider;
import com.microsoft.azure.eventhubs.JsonSecurityToken;
import com.microsoft.azure.eventhubs.SecurityToken;
import java.text.ParseException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class AzureActiveDirectoryTokenProvider
implements ITokenProvider {
    private final AuthenticationCallback authCallback;
    private final String authority;
    private final Object authCallbackState;

    public AzureActiveDirectoryTokenProvider(AuthenticationCallback authenticationCallback, String authority, Object state) {
        this.authCallbackState = state;
        this.authority = authority;
        this.authCallback = authenticationCallback;
    }

    @Override
    public CompletableFuture<SecurityToken> getToken(String resource, Duration timeout) {
        return this.authCallback.acquireToken("https://eventhubs.azure.net/", this.authority, this.authCallbackState).thenApply(rawToken -> {
            try {
                return new JsonSecurityToken((String)rawToken, resource);
            }
            catch (ParseException e) {
                throw new CompletionException(e);
            }
        });
    }

    public static interface AuthenticationCallback {
        public CompletableFuture<String> acquireToken(String var1, String var2, Object var3);
    }
}

