/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.NotNullFunction;
import org.jetbrains.kotlin.com.intellij.util.containers.SLRUMap;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.EqualityPolicy;

@ApiStatus.Internal
public abstract class SLRUCache<K, V>
extends SLRUMap<K, V> {
    protected SLRUCache(int protectedQueueSize, int probationalQueueSize) {
        super(protectedQueueSize, probationalQueueSize);
    }

    protected SLRUCache(int protectedQueueSize, int probationalQueueSize, @NotNull EqualityPolicy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            SLRUCache.$$$reportNull$$$0(0);
        }
        super(protectedQueueSize, probationalQueueSize, hashingStrategy);
    }

    @NotNull
    public abstract V createValue(K var1);

    @Override
    @NotNull
    public V get(K key) {
        V value2 = this.getIfCached(key);
        if (value2 != null) {
            V v = value2;
            if (v == null) {
                SLRUCache.$$$reportNull$$$0(1);
            }
            return v;
        }
        value2 = this.createValue(key);
        this.put(key, value2);
        V v = value2;
        if (v == null) {
            SLRUCache.$$$reportNull$$$0(2);
        }
        return v;
    }

    @Nullable
    public V getIfCached(K key) {
        return super.get(key);
    }

    @NotNull
    public static <K, V> SLRUCache<K, V> slruCache(int protectedQueueSize, int probationalQueueSize, final @NotNull @NotNull Function<@NotNull K, @NotNull V> valueProducer) {
        if (valueProducer == null) {
            SLRUCache.$$$reportNull$$$0(3);
        }
        return new SLRUCache<K, V>(protectedQueueSize, probationalQueueSize){

            @Override
            @NotNull
            public V createValue(K key) {
                Object r = valueProducer.apply(key);
                if (r == null) {
                    1.$$$reportNull$$$0(0);
                }
                return r;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/SLRUCache$1", "createValue"));
            }
        };
    }

    @Deprecated
    @NotNull
    public static <K, V> SLRUCache<K, V> create(int protectedQueueSize, int probationalQueueSize, @NotNull NotNullFunction<? super K, ? extends V> valueProducer) {
        if (valueProducer == null) {
            SLRUCache.$$$reportNull$$$0(4);
        }
        return SLRUCache.slruCache(protectedQueueSize, probationalQueueSize, valueProducer::fun);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/SLRUCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/SLRUCache";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "slruCache";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

