/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectListener;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.NativeAIPlayer;
import net.sf.freecol.server.ai.REFAIPlayer;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;

public class AIMain
extends FreeColObject
implements FreeColGameObjectListener {
    private static final Logger logger = Logger.getLogger(AIMain.class.getName());
    public static final String TAG = "aiMain";
    private final FreeColServer freeColServer;
    private int nextId = 1;
    private final Map<String, AIObject> aiObjects = new HashMap<String, AIObject>();
    private static final String NEXT_ID_TAG = "nextId";
    private static final String OLD_GOODS_WISH_TAG = "GoodsWish";
    private static final String OLD_TILE_IMPROVEMENT_PLAN_TAG = "tileimprovementplan";

    public AIMain(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
    }

    public AIMain(FreeColServer freeColServer, FreeColXMLReader xr) throws XMLStreamException {
        this(freeColServer);
        this.readFromXML(xr);
    }

    public FreeColServer getFreeColServer() {
        return this.freeColServer;
    }

    @Override
    public Game getGame() {
        return this.freeColServer.getGame();
    }

    public String getNextId() {
        String id = Integer.toString(this.nextId);
        ++this.nextId;
        return id;
    }

    public int getRandomSeed(String logMe) {
        return RandomUtils.randomInt(logger, logMe, this.freeColServer.getServerRandom(), Integer.MAX_VALUE);
    }

    private boolean shouldHaveAIObject(FreeColGameObject fcgo) {
        return fcgo instanceof Colony ? true : (fcgo instanceof Player ? ((Player)fcgo).isAI() : fcgo instanceof Unit);
    }

    public void findNewObjects(boolean overwrite) {
        for (FreeColGameObject fcgo : this.freeColServer.getGame().getFreeColGameObjectList()) {
            if (!this.shouldHaveAIObject(fcgo) || !overwrite && this.getAIObject(fcgo) != null) continue;
            this.setFreeColGameObject(fcgo.getId(), fcgo);
        }
    }

    private AIObject getAIObject(FreeColGameObject fcgo) {
        return this.getAIObject(fcgo.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIObject getAIObject(String id) {
        Map<String, AIObject> map = this.aiObjects;
        synchronized (map) {
            return this.aiObjects.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAIObject(String id, AIObject aiObject) {
        boolean present;
        if (aiObject == null) {
            throw new NullPointerException("aiObject == null: " + this);
        }
        Map<String, AIObject> map = this.aiObjects;
        synchronized (map) {
            present = this.aiObjects.containsKey(id);
            if (!present) {
                this.aiObjects.put(id, aiObject);
            }
        }
        if (present) {
            throw new RuntimeException("AIObject already created: " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAIObject(String id) {
        boolean result;
        Map<String, AIObject> map = this.aiObjects;
        synchronized (map) {
            result = this.aiObjects.remove(id) != null;
        }
        if (result) {
            logger.finest("Removed AI object: " + id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AIObject> getAIObjects() {
        Map<String, AIObject> map = this.aiObjects;
        synchronized (map) {
            return new ArrayList<AIObject>(this.aiObjects.values());
        }
    }

    public <T extends AIObject> T getAIObject(String id, Class<T> returnClass) {
        AIObject aio = this.getAIObject(id);
        try {
            return (T)((AIObject)returnClass.cast(aio));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public AIColony getAIColony(Colony colony) {
        return this.getAIObject(colony.getId(), AIColony.class);
    }

    public AIPlayer getAIPlayer(Player player) {
        return this.getAIObject(player.getId(), AIPlayer.class);
    }

    public AIUnit getAIUnit(Unit unit) {
        return this.getAIObject(unit.getId(), AIUnit.class);
    }

    public Map<String, String> getAIStatistics() {
        HashMap<String, Long> stats = new HashMap<String, Long>();
        for (AIObject aio : this.getAIObjects()) {
            String className = aio.getClass().getSimpleName();
            Long count = (Long)stats.get(className);
            if (count == null) {
                stats.put(className, 1L);
                continue;
            }
            stats.put(className, count + 1L);
        }
        return CollectionUtils.transform(stats.entrySet(), CollectionUtils.alwaysTrue(), Function.identity(), Collectors.toMap(Map.Entry::getKey, e -> Long.toString((Long)e.getValue())));
    }

    public String checkSortConsistency() {
        LogBuilder lb = new LogBuilder(256);
        lb.add("AI object sort inconsistencies");
        lb.mark();
        AIObject[] objects = this.getAIObjects().toArray(new AIObject[0]);
        for (int i0 = 0; i0 < objects.length; ++i0) {
            for (int i1 = i0 + 1; i1 < objects.length; ++i1) {
                int c0 = objects[i0].compareTo(objects[i1]);
                int c1 = objects[i1].compareTo(objects[i0]);
                if (c0 == 0 && c1 == 0 || c0 == -1 && c1 == 1 || c0 == 1 && c1 == -1) continue;
                lb.add("\n  ", objects[i0], " ", objects[i1], " = ", c0, "/", c1);
            }
        }
        return lb.grew(new Object[0]) ? lb.toString() : null;
    }

    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = Constants.IntegrityType.INTEGRITY_GOOD;
        for (AIObject aio : this.getAIObjects()) {
            Constants.IntegrityType integ = aio.checkIntegrity(fix, lb);
            if (integ.safe()) continue;
            if (fix) {
                lb.add("\n  Invalid AIObject dropped: ", aio.getId(), "(", StringUtils.lastPart(aio.getClass().getName(), "."), ")");
                this.removeAIObject(aio.getId());
                aio.dispose();
                result = result.fix();
                continue;
            }
            lb.add("\n  Invalid AIObject: ", aio.getId(), "(", StringUtils.lastPart(aio.getClass().getName(), "."), ")");
            result = result.fail();
        }
        for (FreeColGameObject fcgo : this.getGame().getFreeColGameObjectList()) {
            if (!this.shouldHaveAIObject(fcgo) || this.getAIObject(fcgo.getId()) != null) continue;
            if (fix) {
                lb.add("\n  Missing AIObject added: ", fcgo.getId());
                this.setFreeColGameObject(fcgo.getId(), fcgo);
                result = result.fix();
                continue;
            }
            lb.add("\n  Missing AIObject: ", fcgo.getId());
            result = result.fail();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFreeColGameObject(String id, FreeColGameObject fcgo) {
        void var3_10;
        if (this.getAIObject(id) != null || !this.shouldHaveAIObject(fcgo)) {
            return;
        }
        if (!id.equals(fcgo.getId())) {
            throw new RuntimeException("!id.equals(fcgo.getId()): " + id);
        }
        Object var3_3 = null;
        if (fcgo instanceof Colony) {
            AIColony aIColony = new AIColony(this, (Colony)fcgo);
        } else if (fcgo instanceof Player) {
            Player player = (Player)fcgo;
            if (player.getPlayerType() == null) {
                logger.info("Temporarily ignoring incomplete AI player: " + fcgo.getId());
            } else if (player.isIndian()) {
                NativeAIPlayer nativeAIPlayer = new NativeAIPlayer(this, player);
            } else if (player.isREF()) {
                REFAIPlayer rEFAIPlayer = new REFAIPlayer(this, player);
            } else {
                if (!player.isEuropean()) throw new RuntimeException("Bogus player: " + player);
                EuropeanAIPlayer europeanAIPlayer = new EuropeanAIPlayer(this, player);
            }
        } else if (fcgo instanceof Unit) {
            AIUnit aIUnit = new AIUnit(this, (Unit)fcgo);
        }
        if (var3_10 != null) return;
        throw new RuntimeException("Bogus non-AI FCGO: " + fcgo);
    }

    @Override
    public void removeFreeColGameObject(String id) {
        AIObject o = this.getAIObject(id);
        if (o != null) {
            o.dispose();
        }
        this.removeAIObject(id);
    }

    @Override
    public void ownerChanged(FreeColGameObject source, Player oldOwner, Player newOwner) {
        AIObject ao = this.getAIObject(source);
        if (ao == null) {
            return;
        }
        logger.finest("Owner changed for " + source.getId() + " with AI object: " + ao);
        AIPlayer oldAIOwner = this.getAIPlayer(oldOwner);
        if (oldAIOwner != null) {
            oldAIOwner.removeAIObject(ao);
        }
        ao.dispose();
        this.setFreeColGameObject(source.getId(), source);
    }

    @Override
    public Specification getSpecification() {
        return this.getGame().getSpecification();
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        AIMain o = this.copyInCast(other, AIMain.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.nextId = o.nextId;
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeAttribute(NEXT_ID_TAG, this.nextId);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (AIObject aio : CollectionUtils.sort(this.getAIObjects())) {
            if (!aio.checkIntegrity(false).safe()) {
                aio.dispose();
                continue;
            }
            if (aio instanceof Wish && !((Wish)aio).shouldBeStored()) continue;
            try {
                if (aio.getId() == null) {
                    logger.warning("Null AI identifier for: " + aio.getClass().getName());
                    continue;
                }
                aio.toXML(xw);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to write AI object: " + aio, e);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        this.nextId = xr.getAttribute(NEXT_ID_TAG, -1);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.aiObjects.clear();
        super.readChildren(xr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        String oid = xr.readId();
        try {
            AIObject aio = null;
            boolean indirect = false;
            if (oid != null && (aio = this.getAIObject(oid)) != null) {
                aio.readFromXML(xr);
                aio.setInitialized();
            } else if ("aiColony".equals(tag)) {
                aio = new AIColony(this, xr);
            } else if ("aiGoods".equals(tag)) {
                aio = new AIGoods(this, xr);
            } else if ("aiPlayer".equals(tag)) {
                Player p = this.getGame().getFreeColGameObject(oid, Player.class);
                if (p != null) {
                    if (p.isIndian()) {
                        aio = new NativeAIPlayer(this, xr);
                    } else if (p.isREF()) {
                        aio = new REFAIPlayer(this, xr);
                    } else {
                        if (!p.isEuropean()) throw new XMLStreamException("Bogus AIPlayer: " + p);
                        aio = new EuropeanAIPlayer(this, xr);
                    }
                }
            } else if ("aiUnit".equals(tag)) {
                aio = new AIUnit(this, xr);
            } else if ("goodsWish".equals(tag) || OLD_GOODS_WISH_TAG.equals(tag)) {
                aio = new GoodsWish(this, xr);
            } else if ("tileImprovementPlan".equals(tag) || OLD_TILE_IMPROVEMENT_PLAN_TAG.equals(tag)) {
                aio = new TileImprovementPlan(this, xr);
            } else if ("workerWish".equals(tag)) {
                aio = new WorkerWish(this, xr);
            } else {
                System.err.println("AT " + tag + " with " + oid);
                indirect = true;
                super.readChild(xr);
            }
            if (aio != null || indirect) return;
            throw new XMLStreamException("Bad AI object at " + tag + " with " + oid);
        }
        catch (XMLStreamException xse) {
            throw xse;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception reading AIObject: " + tag + ", id=" + oid, e);
            String mainTag = TAG;
        }
        while (xr.moreTags() || !xr.atTag(tag) && !xr.atTag(TAG)) {
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

