/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.util.StringUtil;

public class TcpEndpointContext
extends MapBasedEndpointContext {
    public static final String KEY_CONNECTION_ID = "CONNECTION_ID";

    public TcpEndpointContext(InetSocketAddress peerAddress, String connectionId) {
        this(peerAddress, null, KEY_CONNECTION_ID, connectionId);
    }

    protected TcpEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, String ... attributes) {
        super(peerAddress, peerIdentity, attributes);
        if (null == this.getConnectionId()) {
            throw new IllegalArgumentException("Missing attribute ");
        }
    }

    public String getConnectionId() {
        return this.get(KEY_CONNECTION_ID);
    }

    @Override
    public String toString() {
        return String.format("TCP(%s,ID:%s)", this.getPeerAddressAsString(), StringUtil.trunc(this.getConnectionId(), 10));
    }
}

