/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class AbstractInfoAction
extends JosmAction {
    public AbstractInfoAction(boolean installAdapters) {
        super(installAdapters);
    }

    public AbstractInfoAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register, String toolbarId, boolean installAdapters) {
        super(name, iconName, tooltip, shortcut, register, toolbarId, installAdapters);
    }

    public static boolean confirmLaunchMultiple(int numBrowsers) {
        String msg = I18n.trn("You are about to launch {0} browser window.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", "You are about to launch {0} browser windows.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", numBrowsers, numBrowsers);
        HelpAwareOptionPane.ButtonSpec[] spec = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue", new Object[0]), new ImageProvider("ok"), I18n.trn("Click to continue and to open {0} browser", "Click to continue and to open {0} browsers", numBrowsers, numBrowsers), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to abort launching external browsers", new Object[0]), null)};
        return 0 == HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), new StringBuilder(msg).insert(0, "<html>").append("</html>").toString(), I18n.tr("Warning", new Object[0]), 2, null, spec, spec[0], HelpUtil.ht("/WarningMessages#ToManyBrowsersToOpen"));
    }

    protected void launchInfoBrowsersForSelectedPrimitivesAndNote() {
        ArrayList<Object> primitivesToShow = new ArrayList<Object>();
        OsmData<?, ?, ?, ?> ds = this.getLayerManager().getActiveData();
        if (ds != null) {
            primitivesToShow.addAll(ds.getAllSelected());
        }
        Note noteToShow = MainApplication.isDisplayingMapView() ? MainApplication.getMap().noteDialog.getSelectedNote() : null;
        primitivesToShow.removeIf(PrimitiveId::isNew);
        if (primitivesToShow.isEmpty() && noteToShow == null) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Please select at least one already uploaded node, way, or relation.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        int max = Math.min(10, primitivesToShow.size());
        if (primitivesToShow.size() > max && !AbstractInfoAction.confirmLaunchMultiple(primitivesToShow.size())) {
            return;
        }
        for (int i = 0; i < max; ++i) {
            this.launchInfoBrowser(primitivesToShow.get(i));
        }
        if (noteToShow != null) {
            this.launchInfoBrowser(noteToShow);
        }
    }

    protected final void launchInfoBrowser(Object o) {
        String result;
        String url = this.createInfoUrl(o);
        if (url != null && (result = OpenBrowser.displayUrl(url)) != null) {
            Logging.warn(result);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.launchInfoBrowsersForSelectedPrimitivesAndNote();
    }

    protected abstract String createInfoUrl(Object var1);

    @Override
    protected void updateEnabledState() {
        OsmData<?, ?, ?, ?> ds = this.getLayerManager().getActiveData();
        this.setEnabled(ds != null && !ds.selectionEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

