/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.model.javafragment.ImportsFragment;
import org.jd.core.v1.model.javafragment.StartSingleStatementBlockFragment;
import org.jd.core.v1.model.javafragment.StartStatementsBlockFragment;
import org.jd.core.v1.model.javafragment.TokensFragment;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.statement.AssertStatement;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.ByteCodeStatement;
import org.jd.core.v1.model.javasyntax.statement.CommentStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.DoWhileStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ForEachStatement;
import org.jd.core.v1.model.javasyntax.statement.ForStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.LabelStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.LocalVariableDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.SynchronizedStatement;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.statement.TypeDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.token.EndBlockToken;
import org.jd.core.v1.model.token.EndMarkerToken;
import org.jd.core.v1.model.token.KeywordToken;
import org.jd.core.v1.model.token.NewLineToken;
import org.jd.core.v1.model.token.StartBlockToken;
import org.jd.core.v1.model.token.StartMarkerToken;
import org.jd.core.v1.model.token.TextToken;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.util.JavaFragmentFactory;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor.ExpressionVisitor;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor.TypeVisitor;
import org.jd.core.v1.util.DefaultList;

public class StatementVisitor
extends ExpressionVisitor {
    public static final KeywordToken ASSERT = new KeywordToken("assert");
    public static final KeywordToken BREAK = new KeywordToken("break");
    public static final KeywordToken CASE = new KeywordToken("case");
    public static final KeywordToken CATCH = new KeywordToken("catch");
    public static final KeywordToken CONTINUE = new KeywordToken("continue");
    public static final KeywordToken DEFAULT = new KeywordToken("default");
    public static final KeywordToken DO = new KeywordToken("do");
    public static final KeywordToken ELSE = new KeywordToken("else");
    public static final KeywordToken FINAL = new KeywordToken("final");
    public static final KeywordToken FINALLY = new KeywordToken("finally");
    public static final KeywordToken FOR = new KeywordToken("for");
    public static final KeywordToken IF = new KeywordToken("if");
    public static final KeywordToken RETURN = new KeywordToken("return");
    public static final KeywordToken STRICT = new KeywordToken("strictfp");
    public static final KeywordToken SYNCHRONIZED = new KeywordToken("synchronized");
    public static final KeywordToken SWITCH = new KeywordToken("switch");
    public static final KeywordToken THROW = new KeywordToken("throw");
    public static final KeywordToken TRANSIENT = new KeywordToken("transient");
    public static final KeywordToken TRY = new KeywordToken("try");
    public static final KeywordToken VOLATILE = new KeywordToken("volatile");
    public static final KeywordToken WHILE = new KeywordToken("while");

    public StatementVisitor(Loader loader, String mainInternalTypeName, int majorVersion, ImportsFragment importsFragment) {
        super(loader, mainInternalTypeName, majorVersion, importsFragment);
    }

    @Override
    public void visit(AssertStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
        this.tokens.add(ASSERT);
        this.tokens.add(TextToken.SPACE);
        statement.getCondition().accept(this);
        Expression msg = statement.getMessage();
        if (msg != null) {
            this.tokens.add(TextToken.SPACE_COLON_SPACE);
            msg.accept(this);
        }
        this.tokens.add(TextToken.SEMICOLON);
        this.tokens.add(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(BreakStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(BREAK);
        if (statement.getLabel() != null) {
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(this.newTextToken(statement.getLabel()));
        }
        this.tokens.add(TextToken.SEMICOLON);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(ByteCodeStatement statement) {
        this.visitComment(statement.getText());
    }

    @Override
    public void visit(CommentStatement statement) {
        this.visitComment(statement.getText());
    }

    protected void visitComment(String text) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartMarkerToken.COMMENT);
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            this.tokens.add(new TextToken(st.nextToken()));
            this.tokens.add(NewLineToken.NEWLINE_1);
        }
        this.tokens.remove(this.tokens.size() - 1);
        this.tokens.add(EndMarkerToken.COMMENT);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(ContinueStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(CONTINUE);
        if (statement.getLabel() != null) {
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(this.newTextToken(statement.getLabel()));
        }
        this.tokens.add(TextToken.SEMICOLON);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(DoWhileStatement statement) {
        StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsDoWhileBlock(this.fragments);
        this.safeAccept(statement.getStatements());
        JavaFragmentFactory.addEndStatementsBlock(this.fragments, group);
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(WHILE);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getCondition().accept(this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        this.tokens.add(TextToken.SEMICOLON);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(ExpressionStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
        statement.getExpression().accept(this);
        this.tokens.add(TextToken.SEMICOLON);
        this.tokens.add(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(ForStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(FOR);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        this.safeAccept(statement.getDeclaration());
        this.safeAccept(statement.getInit());
        if (statement.getCondition() == null) {
            this.tokens.add(TextToken.SEMICOLON);
        } else {
            this.tokens.add(TextToken.SEMICOLON_SPACE);
            statement.getCondition().accept(this);
        }
        if (statement.getUpdate() == null) {
            this.tokens.add(TextToken.SEMICOLON);
        } else {
            this.tokens.add(TextToken.SEMICOLON_SPACE);
            statement.getUpdate().accept(this);
        }
        this.visitLoopStatements(statement.getStatements());
    }

    @Override
    public void visit(ForEachStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(FOR);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        Type type = statement.getType();
        type.accept(this);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(this.newTextToken(statement.getName()));
        this.tokens.add(TextToken.SPACE_COLON_SPACE);
        statement.getExpression().accept(this);
        this.visitLoopStatements(statement.getStatements());
    }

    protected void visitLoopStatements(BaseStatement statements) {
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
        if (statements == null) {
            this.tokens.add(TextToken.SEMICOLON);
        } else {
            ExpressionVisitor.Fragments tmp = this.fragments;
            this.fragments = new ExpressionVisitor.Fragments();
            statements.accept(this);
            switch (this.fragments.size()) {
                case 0: {
                    this.tokens.add(TextToken.SEMICOLON);
                    break;
                }
                case 1: {
                    StartSingleStatementBlockFragment start = JavaFragmentFactory.addStartSingleStatementBlock(tmp);
                    tmp.addAll(this.fragments);
                    JavaFragmentFactory.addEndSingleStatementBlock(tmp, start);
                    break;
                }
                default: {
                    StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsBlock(tmp);
                    tmp.addAll(this.fragments);
                    JavaFragmentFactory.addEndStatementsBlock(tmp, group);
                }
            }
            this.fragments = tmp;
        }
    }

    @Override
    public void visit(IfStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(IF);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getCondition().accept(this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
        BaseStatement stmt = statement.getStatements();
        if (stmt == null) {
            this.fragments.add(TokensFragment.SEMICOLON);
        } else {
            ExpressionVisitor.Fragments tmp = this.fragments;
            this.fragments = new ExpressionVisitor.Fragments();
            stmt.accept(this);
            if (stmt.getClass() == Statements.class) {
                Statements sal = (Statements)stmt;
                switch (sal.size()) {
                    case 0: {
                        tmp.add(TokensFragment.SEMICOLON);
                        break;
                    }
                    case 1: {
                        StartSingleStatementBlockFragment start = JavaFragmentFactory.addStartSingleStatementBlock(tmp);
                        tmp.addAll(this.fragments);
                        JavaFragmentFactory.addEndSingleStatementBlock(tmp, start);
                        break;
                    }
                    default: {
                        StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsBlock(tmp);
                        tmp.addAll(this.fragments);
                        JavaFragmentFactory.addEndStatementsBlock(tmp, group);
                        break;
                    }
                }
            } else {
                StartSingleStatementBlockFragment start = JavaFragmentFactory.addStartSingleStatementBlock(tmp);
                tmp.addAll(this.fragments);
                JavaFragmentFactory.addEndSingleStatementBlock(tmp, start);
            }
            this.fragments = tmp;
        }
    }

    @Override
    public void visit(IfElseStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(IF);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getCondition().accept(this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
        StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsBlock(this.fragments);
        statement.getStatements().accept(this);
        JavaFragmentFactory.addEndStatementsBlock(this.fragments, group);
        this.visitElseStatements(statement.getElseStatements(), group);
    }

    protected void visitElseStatements(BaseStatement elseStatements, StartStatementsBlockFragment.Group group) {
        BaseStatement statementList = elseStatements;
        if (elseStatements.isList() && elseStatements.size() == 1) {
            statementList = (BaseStatement)elseStatements.getFirst();
        }
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(ELSE);
        if (statementList.getClass() == IfElseStatement.class) {
            IfElseStatement iss = (IfElseStatement)statementList;
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(IF);
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
            iss.getCondition().accept(this);
            this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
            this.fragments.addTokensFragment(this.tokens);
            JavaFragmentFactory.addStartStatementsBlock(this.fragments, group);
            iss.getStatements().accept(this);
            JavaFragmentFactory.addEndStatementsBlock(this.fragments, group);
            this.visitElseStatements(iss.getElseStatements(), group);
        } else if (statementList.getClass() == IfStatement.class) {
            IfStatement is = (IfStatement)statementList;
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(IF);
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
            is.getCondition().accept(this);
            this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
            this.fragments.addTokensFragment(this.tokens);
            JavaFragmentFactory.addStartStatementsBlock(this.fragments, group);
            is.getStatements().accept(this);
            JavaFragmentFactory.addEndStatementsBlock(this.fragments, group);
        } else {
            this.fragments.addTokensFragment(this.tokens);
            JavaFragmentFactory.addStartStatementsBlock(this.fragments, group);
            elseStatements.accept(this);
            JavaFragmentFactory.addEndStatementsBlock(this.fragments, group);
        }
    }

    @Override
    public void visit(LabelStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(this.newTextToken(statement.getLabel()));
        this.tokens.add(TextToken.COLON);
        if (statement.getStatement() == null) {
            this.fragments.addTokensFragment(this.tokens);
        } else {
            this.tokens.add(TextToken.SPACE);
            this.fragments.addTokensFragment(this.tokens);
            statement.getStatement().accept(this);
        }
    }

    @Override
    public void visit(LambdaExpressionStatement statement) {
        statement.getExpression().accept(this);
    }

    @Override
    public void visit(LocalVariableDeclarationStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
        if (statement.isFinal()) {
            this.tokens.add(FINAL);
            this.tokens.add(TextToken.SPACE);
        }
        Type type = statement.getType();
        type.accept(this);
        this.tokens.add(TextToken.SPACE);
        statement.getLocalVariableDeclarators().accept(this);
        this.tokens.add(TextToken.SEMICOLON);
        this.tokens.add(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(ReturnExpressionStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
        this.tokens.addLineNumberToken(statement.getLineNumber());
        this.tokens.add(RETURN);
        this.tokens.add(TextToken.SPACE);
        statement.getExpression().accept(this);
        this.tokens.add(TextToken.SEMICOLON);
        this.tokens.add(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(ReturnStatement statement) {
        this.fragments.add(TokensFragment.RETURN_SEMICOLON);
    }

    @Override
    public void visit(Statements list) {
        int size = list.size();
        if (size > 0) {
            Iterator iterator = list.iterator();
            ((Statement)iterator.next()).accept(this);
            for (int i = 1; i < size; ++i) {
                JavaFragmentFactory.addSpacerBetweenStatements(this.fragments);
                ((Statement)iterator.next()).accept(this);
            }
        }
    }

    @Override
    public void visit(SwitchStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(SWITCH);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getCondition().accept(this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
        StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsBlock(this.fragments);
        Iterator<SwitchStatement.Block> iterator = statement.getBlocks().iterator();
        if (iterator.hasNext()) {
            iterator.next().accept(this);
            while (iterator.hasNext()) {
                JavaFragmentFactory.addSpacerBetweenSwitchLabelBlock(this.fragments);
                iterator.next().accept(this);
            }
        }
        JavaFragmentFactory.addEndStatementsBlock(this.fragments, group);
        JavaFragmentFactory.addSpacerAfterEndStatementsBlock(this.fragments);
    }

    @Override
    public void visit(SwitchStatement.LabelBlock statement) {
        statement.getLabel().accept(this);
        JavaFragmentFactory.addSpacerAfterSwitchLabel(this.fragments);
        statement.getStatements().accept(this);
        JavaFragmentFactory.addSpacerAfterSwitchBlock(this.fragments);
    }

    @Override
    public void visit(SwitchStatement.DefaultLabel statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(DEFAULT);
        this.tokens.add(TextToken.COLON);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(SwitchStatement.ExpressionLabel statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(CASE);
        this.tokens.add(TextToken.SPACE);
        statement.getExpression().accept(this);
        this.tokens.add(TextToken.COLON);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(SwitchStatement.MultiLabelsBlock statement) {
        Iterator<SwitchStatement.Label> iterator = statement.getLabels().iterator();
        if (iterator.hasNext()) {
            iterator.next().accept(this);
            while (iterator.hasNext()) {
                JavaFragmentFactory.addSpacerBetweenSwitchLabels(this.fragments);
                iterator.next().accept(this);
            }
        }
        JavaFragmentFactory.addSpacerAfterSwitchLabel(this.fragments);
        statement.getStatements().accept(this);
        JavaFragmentFactory.addSpacerAfterSwitchBlock(this.fragments);
    }

    @Override
    public void visit(SynchronizedStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(SYNCHRONIZED);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getMonitor().accept(this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        BaseStatement statements = statement.getStatements();
        if (statements == null) {
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(TextToken.LEFTRIGHTCURLYBRACKETS);
            this.fragments.addTokensFragment(this.tokens);
        } else {
            this.fragments.addTokensFragment(this.tokens);
            StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsBlock(this.fragments);
            statements.accept(this);
            JavaFragmentFactory.addEndStatementsBlock(this.fragments, group);
        }
    }

    @Override
    public void visit(ThrowStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
        this.tokens.add(THROW);
        this.tokens.add(TextToken.SPACE);
        statement.getExpression().accept(this);
        this.tokens.add(TextToken.SEMICOLON);
        this.tokens.add(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(TryStatement statement) {
        StartStatementsBlockFragment.Group group;
        DefaultList<TryStatement.Resource> resources = statement.getResources();
        if (resources == null) {
            group = JavaFragmentFactory.addStartStatementsTryBlock(this.fragments);
        } else {
            int size = resources.size();
            assert (size > 0);
            this.tokens = new TypeVisitor.Tokens(this);
            this.tokens.add(TRY);
            if (size == 1) {
                this.tokens.add(TextToken.SPACE);
            }
            this.tokens.add(StartBlockToken.START_RESOURCES_BLOCK);
            ((TryStatement.Resource)resources.get(0)).accept(this);
            for (int i = 1; i < size; ++i) {
                this.tokens.add(TextToken.SEMICOLON_SPACE);
                ((TryStatement.Resource)resources.get(i)).accept(this);
            }
            this.tokens.add(EndBlockToken.END_RESOURCES_BLOCK);
            this.fragments.addTokensFragment(this.tokens);
            group = JavaFragmentFactory.addStartStatementsBlock(this.fragments);
        }
        this.visitTryStatement(statement, group);
    }

    @Override
    public void visit(TryStatement.Resource resource) {
        Expression expression = resource.getExpression();
        this.tokens.addLineNumberToken(expression);
        ObjectType type = resource.getType();
        type.accept(this);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(this.newTextToken(resource.getName()));
        this.tokens.add(TextToken.SPACE_EQUAL_SPACE);
        expression.accept(this);
    }

    protected void visitTryStatement(TryStatement statement, StartStatementsBlockFragment.Group group) {
        int fragmentCount1;
        int fragmentCount2 = fragmentCount1 = this.fragments.size();
        statement.getTryStatements().accept(this);
        if (statement.getCatchClauses() != null) {
            for (TryStatement.CatchClause cc : statement.getCatchClauses()) {
                JavaFragmentFactory.addEndStatementsBlock(this.fragments, group);
                ObjectType type = cc.getType();
                this.tokens = new TypeVisitor.Tokens(this);
                this.tokens.add(CATCH);
                this.tokens.add(TextToken.SPACE_LEFTROUNDBRACKET);
                this.tokens.add(this.newTypeReferenceToken(type, this.currentInternalTypeName));
                if (cc.getOtherTypes() != null) {
                    for (ObjectType otherType : cc.getOtherTypes()) {
                        this.tokens.add(TextToken.VERTICALLINE);
                        this.tokens.add(this.newTypeReferenceToken(otherType, this.currentInternalTypeName));
                    }
                }
                this.tokens.add(TextToken.SPACE);
                this.tokens.add(this.newTextToken(cc.getName()));
                this.tokens.add(TextToken.RIGHTROUNDBRACKET);
                int lineNumber = cc.getLineNumber();
                if (lineNumber == 0) {
                    this.fragments.addTokensFragment(this.tokens);
                } else {
                    this.tokens.addLineNumberToken(lineNumber);
                    this.fragments.addTokensFragment(this.tokens);
                }
                fragmentCount1 = this.fragments.size();
                JavaFragmentFactory.addStartStatementsBlock(this.fragments, group);
                fragmentCount2 = this.fragments.size();
                cc.getStatements().accept(this);
            }
        }
        if (statement.getFinallyStatements() != null) {
            JavaFragmentFactory.addEndStatementsBlock(this.fragments, group);
            this.tokens = new TypeVisitor.Tokens(this);
            this.tokens.add(FINALLY);
            this.fragments.addTokensFragment(this.tokens);
            fragmentCount1 = this.fragments.size();
            JavaFragmentFactory.addStartStatementsBlock(this.fragments, group);
            fragmentCount2 = this.fragments.size();
            statement.getFinallyStatements().accept(this);
        }
        if (fragmentCount2 == this.fragments.size()) {
            this.fragments.subList(fragmentCount1, fragmentCount2).clear();
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(TextToken.LEFTRIGHTCURLYBRACKETS);
        } else {
            JavaFragmentFactory.addEndStatementsBlock(this.fragments, group);
        }
    }

    @Override
    public void visit(TypeDeclarationStatement statement) {
        statement.getTypeDeclaration().accept(this);
        this.fragments.add(TokensFragment.SEMICOLON);
    }

    @Override
    public void visit(WhileStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(WHILE);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getCondition().accept(this);
        this.visitLoopStatements(statement.getStatements());
    }
}

