/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.Map;
import java.util.Properties;
import net.i2p.data.Hash;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.router.ClientTunnelSettings;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

class CreateSessionJob
extends JobImpl {
    private final Log _log;
    private final SessionConfig _config;

    public CreateSessionJob(RouterContext context, SessionConfig config) {
        super(context);
        this._log = context.logManager().getLog(CreateSessionJob.class);
        this._config = config;
        if (this._log.shouldLog(10)) {
            this._log.debug("CreateSessionJob for config: " + config);
        }
    }

    @Override
    public String getName() {
        return "Request tunnels for a new client";
    }

    @Override
    public void runJob() {
        Hash dest = this._config.getDestination().calculateHash();
        if (this._log.shouldLog(20)) {
            this._log.info("Requesting lease set for destination " + dest);
        }
        ClientTunnelSettings settings = new ClientTunnelSettings(dest);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this._config.getOptions());
        settings.readFromProperties(props);
        this.getContext().tunnelManager().buildTunnels(this._config.getDestination(), settings);
    }
}

