.\" @(#)xbevel.man
.\"
.\" Copyright 2023 - 2024  David A. Bagley
.\"
.\" All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "useful",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH XBEVEL 6 "15 Aug 2024" "V8.8.4"
.SH NAME
xbevel \- Bevel X widgets
.SH SYNOPSIS
.B /usr/games/xbevel
[\-geometry [{width}][x{height}][{+\-}{xoff}[{+\-}{yoff}]]]
[\-display [{host}]:[{vs}]] [\-[no]mono] [\-[no]{reverse|rv}]
[\-{foreground|fg} {color}] [\-{background|bg} {color}]
[\-{border|bd} {color}] [\-face{0|1|2|3|4|5} {color}]
[\-frame {color}] [\-delay msecs] [\-[no]sound]
[\-moveSound {filename}] [\-{font|fn} {fontname}]
[\-view {int}] [\-[no]orient] [\-[no]practice]
[\-userName {string}] [\-scoreFile {filename}]
[\-scores] [\-version]
.SH DESCRIPTION
.LP
The original puzzle looks like a 2x2x2 Rubik Cube with extra cuts like
a Skewb with 24 inner pieces and 8 outer pieces.  This was designed by
Adam G. Cowan in 2005 and is more widely known as the Helicopter Cube.
This Bevel puzzle has 7!*3^6*6!^4/2 or 4.94*10^17 different
combinations.  This program does not permit ~71 degree turns only
180 degree turns.  If it did, it would have 7!*3^6*24!/4!^6 or
1.19*10^22 combinations.
.SH FEATURES
.LP
Press "\fBmouse\-left\fP" button to move a piece.  Release
"\fBmouse\-left\fP" button on a piece on the same face.  (Clicks on
diamonds are ignored).  The pieces will then turn towards where the mouse
button was released.
.LP
Click "\fBmouse\-center\fP", or press "\fBP\fP" or "\fBp\fP" keys to toggle
the practice mode (in practice mode the record should say "practice").
This is good for learning moves and experimenting.
.LP
Click "\fBmouse\-right\fP", or press "\fBZ\fP" or "\fBz\fP" keys, to
randomize the puzzle (this must be done first to set a new record).
.LP
Press "\fBG\fP" or "\fBg\fP" keys to read (get) a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to save (write) a puzzle.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBR\fP" or "\fBr\fP" keys to redo a move.
.LP
Press "\fBC\fP" or "\fBc\fP" keys to clear the puzzle.
.LP
"\fBS\fP" or "\fBs\fP" keys to start auto\-solver currently only
implemented when orient mode is off.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the orient mode.  One has to
orient the faces in orient mode, besides getting all the faces to be the
same color.  This does add complexity so there are 2 sets of records.
.LP
Press "\fBV\fP" or "\fBv\fP" keys to change the view of the puzzle.
.LP
Press "\fB>\fP" or "\fB.\fP" keys to speed up the movement of pieces
(not implemented).
.LP
Press "\fB<\fP" or "\fB,\fP" keys to slow down the movement of pieces
(not implemented).
.LP
Press "\fB@\fP" key to toggle the sound.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL\-C\fP" keys to kill program.
.LP
Use the key pad or arrow keys to move without the mouse.
.br
Key pad is defined for the Bevel2d as:
.br
  /     Counterclockwise
.sp
7 8 9   Upper Left, Up, Upper Right
.br
  ^
.br
4<5>6   Left, Clockwise, Right
.br
  v
.br
1 2 3   Lower Left, Down, Lower Right
.sp
Key pad for other than Bevel2d, use must use your intuition (is this a cop
out or what?).  The key pad is defined differently depending on which side
of the cube your mouse is pointing at.  One thing that stays the same is "5"
is Clockwise and "/" is Counterclockwise.
.LP
Use the control key and the left mouse button, keypad, or arrow keys to
move the whole cube.  Its also possible to rotate whole cube with an axis
through a face with alt key is pressed (Tab key when using Windows).
This is not recorded as a turn.
.LP
The title is in the following format (non\-motif non\-opengl version):
.RS
xbevel{2|3}d<dimension>: (<Number of moves>/{<Record number of moves>
<user name>|"NEVER noaccess"|"practice"}) \- <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the bevel window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to display the bevel window on a color screen as if
it were monochrome (resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the bevel window in reverse video
(resource name "\fIreverseVideo\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the bevel window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the bevel window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the pieces in the bevel
window (resource name "\fIborderColor\fP").
.TP 8
.B \-face{0|1|2|3|4|5} <\fIcolor\fP>
This option allows you to change the color of a face (resource name
"\fIfaceColorN\fP"). In mono\-mode, color is represented as the first letter
of the color name. On the 2\-D version, the faces are ordered top to bottom
and left to right on the "t" configuration. The "+\-" configuration is
physically consistent with the former, so it is ordered "0, 1, 2, 3, 5, 4".
If you has two colors that begin with the same letter you should have one
in uppercase and one in lowercase to distinguish them in mono\-mode. You can
change the colors of the faces to make a stupid cube (i.e. all White or in
mono\-mode all "W"). Unfortunately, it will not normally say its solved when
its randomized. This would be cheating.
.TP 8
.B \-frame \fIcolor\fP
This option specifies the color of the frame (resource name
"\fIframeColor\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move pieces
(1\-50) (resource name "\fIdelay\fP").
.TP 8
.B \-[no]sound
This option specifies if sliding pieces should make a sound or not
(resource name "\fIsound\fP").
.TP 8
.B \-moveSound \fIfilename\fP
This option specifies the file for the move sound for the twisting of
the puzzle (resource name "\fImoveSound\fP").
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-view <\fIint\fP>
This option allows you to change the view of the cube for OpenGL with
choice of 4 views (resource name "\fIint\fP").
.TP 8
.B \-[no]orient
This option allows you to access the oriented mode (resource name
"\fIorient\fP").
.TP 8
.B \-[no]practice
This option allows you to access the practice mode (resource name
"\fIpractice\fP").
.TP 8
.B \-userName \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.TP 8
.B \-scoreFile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-scores
This option lists all the recorded scores and then exits.
.TP 8
.B \-version
This option tells you what version of xbevel you have.
.SH RECORDS
You must randomize the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get or an
auto\-solve.
.SH SAVE FORMAT
Here is the format for the xbevel configuration, starting position, and
the movement of its pieces.
.sp
Bevel2d with default colors, not randomized:
.br
  0       R     Red
.br
1 2 3   Y B O   Yellow, Blue, Orange
.br
  4       W     White
.br
  5       G     Green
.sp
.RS
orient: 0\-1 <0 false, 1 true; if 1 then lines on pieces to be oriented>
.br
practice: 0\-1 <0 false, 1 true>
.br
moves: 0\-MAXINT <total number of moves>
.sp
startingPosition: <2 dimensional array of face and outer trianganular
pieces and 4 inner triangular pieces, if orient mode then orientation
number follows face number: 0 up, 1 right, 2 down, and 3 left>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <direction> <control> <face> <corner>
.RE
Each turn is with respect to a corner on a face.
.br
The corners start at the upper right and work clockwise.
.br
Direction is represented as 0 up, 1 right, 2 down, 3 left, 5 clockwise,
7 counterclockwise, 8 upper right, 9 lower right, 10 lower left, and
11 upper left.
.br
Control is represented as 0 or 1, 1 if the whole cube is moved at once
(here the corner does not matter), 0 if not.  The xbevel record keeper does
not count a control move as a move, but here we do.
.SH REFERENCES
Beyond Rubik's Cube: spheres, pyramids, dodecahedrons and God knows what
else by Douglas R. Hofstadter, Scientific American, July 1982, pp 16\-31.
.sp
https://en.wikipedia.org/wiki/Helicopter_Cube
.SH SEE ALSO
.LP
X(1), xcubes(6), xtriangles(6), xhexagons(6), xmlink(6), xbarrel(6),
xpanex(6), xmball(6), xpyraminx(6), xoct(6), xrubik(6), xskewb, xdino(6),
xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 2023\-2024, David A. Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David A. Bagley, <\fIbagleyd AT verizon.net\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIhttps://www.sillycycle.com/puzzles.html\fP
.br
\fIhttp://www.ibiblio.org/pub/Linux/games/strategy/\fP
