/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef ENABLE_NLS
#include <libintl.h>
#endif

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <locale.h>

#include <gtk/gtk.h>

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif


#include "stdio.h"
#include <string.h>
 #include <stdlib.h>

#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "gtktopdata.h"
//#include "pixmaps.h"


#include "main.h"

#ifndef IS_PLYMORPH
#include "utils.h"
#endif

#include "feature.h"
#include "mag.h"
#include "movies.h"
// no we use g_assert
//#include "assert.h"
//#include "../libmorph/mesh.h"

#include "loadsave.h"

#ifndef IS_PLYMORPH
#include "loadsave_mesh.h"
#else
#include "loadsave_ply.h"
#endif

#include "fourier.hh"
#include "wavelet.hh"

GtkFileSelection   *fileselection_g=NULL; 



/* we will implement UNDO by copying this structure and its substructures */
gtkmorph_status_t  settings,
  *sp = &settings;




/*************** warning code*/


void     null_logger(const gchar *log_domain,
		     GLogLevelFlags log_level,
		     const gchar *message,
		     gpointer user_data)
{}


/* this variable stores the number of the window that we are loading for 
   if this is MAIN_WIN then it refers to the window 
   containing the resulting image
   
   and the element 0 is not used
*/

int fileselection1_for_image_num_g=-3;


/********** the current settings are
  in a "structure of arrays " (see main.h)

  why not an "array of structures"?
  because many subroutines work on the
  arrays, and they would become unnecessarily complicated

  on the other end, a  "array of structures"
  may be easily modified to add new images... this
  way, the program will have to be recompiled to add new images;
  but hopefully MAX_WINS may be set to a value that is sufficient 
  in 99.9% of cases

  */

/* we will implement UNDO by copying this structure and its substructures 
   (the above line was written in 1998 - undo was never implemented )
*/
extern gtkmorph_status_t    *sp;


#ifdef __WIN32__
gchar *program_install_dir=NULL;
#endif

int
main(int argc, char *argv[])
{

  int debug_mode = 0 ;

#ifdef  __WIN32__     
  if(argc>0) {
    program_install_dir=g_path_get_dirname(argv[0]);
  } else g_warning("cannot deduce program install dir from argv");
#endif
  //FIXME to use getopt
  if( argc >1 &&  strcmp(argv[1],"-d")==0) {
    g_debug("argv[0] is  '%s'",argv[0]);
    // avoid this... destroys argv[0] argc--; argv++;
    debug_mode = 1 ;
  }  else
    g_log_set_handler (NULL, G_LOG_LEVEL_DEBUG | G_LOG_FLAG_FATAL
			   | G_LOG_FLAG_RECURSION, null_logger, NULL);

#ifndef __WIN32__
  srand48(0);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  /* numbers in  saved files are messed up by locales otherwise */
  setlocale(LC_NUMERIC, "C");

#if  defined(G_THREADS_ENABLED) && defined(IS_PLYMORPH)
#if GLIB_MAJOR_VERSION >= 2
  //#warning threads are disabled
  if (!g_thread_supported ()) g_thread_init (NULL);
#else
#warning the code for glib-1.2 threads is incomplete and malfunctioning
#endif
#endif

#ifdef ENABLE_NLS
  bindtextdomain ( GETTEXT_PACKAGE, LOCALEDIR);
#if GTK_MAJOR_VERSION >= 2
  /* Mennucc: from here on, all messages will be translated before
     they are passed to GTK, that is, Pango, so they must be UTF-8.
     Thanks to Thomas Huriaux (see http://bugs.debian.org/361260 ) */
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  /* note that this means that any translated  message that may be written to
     the terminal will be UTF-8 as well! Currently messages output from g_warnings
     and such are not translated, so it is not a problem; but, see utils2.c:18  */
#endif
  textdomain ( GETTEXT_PACKAGE);
#endif

#ifdef IS_PLYMORPH
  gtk_gl_init (&argc, &argv);
  init_gl();
  /* try dynamical loading of the ply gizmo */
  if(!bind_libply(argv)) return 1;
#endif


  /* Inititalise GDK : done by gtk_init       gdk_init(&argc,&argv);       */

  gdk_rgb_init();

#ifdef HAVE_X
  //FIXME I think that I need to do something more...
  gdk_set_sm_client_id (PACKAGE);
#endif


#ifdef USE_IMLIB
  {
    /* Immediately after initialising GDK, Initialise Imlib */
    gdk_imlib_init();
    /* Get gdk to use imlib's visual and colormap */
    gtk_widget_push_visual(gdk_imlib_get_visual());
    gtk_widget_push_colormap(gdk_imlib_get_colormap());
  }
#else
  
#endif

#ifdef __WIN32__
  printf("\
*************************************************************************\n\
      gtkmorph         Digital image warp and morph\n\
\n\
gtkmorph: Written and Copyright (C) 2000-2006 by A C G Mennucci\n\
libmorph: Written and Copyright (C) 1994-2000 by Michael J. Gourlay\n\
\n\
    This program is free software; you can redistribute it and/or modify\n\
    it under the terms of the GNU General Public License v2.\n\
    See in the file COPYING.txt\n\
\n\
    This program is distributed in the hope that it will be useful,\n\
    but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
    GNU General Public License for more details.\n\
\n\
*************************************************************************\n\
Don't close this window: this software is still unfinished, and messages \n\
and warnings appear here. If you don't like this window, minimize it.\n\
\n\
");
#endif
  { gchar *P=NULL;
#ifdef  __WIN32__
    if(program_install_dir && P==NULL)  {
      P= g_build_filename(program_install_dir,"pixmaps",NULL);
      if(!g_file_test(P,  G_FILE_TEST_IS_DIR)) {
	 if( debug_mode )
	   g_warning(" the 'pixmaps' directory should be in '%s' but is not",P);
	g_free(P);P=NULL;
      }
    }
#else    
    if(P==NULL &&
       g_file_test(DATADIR "/" PACKAGE "/pixmaps",  G_FILE_TEST_IS_DIR))
      P=g_strdup(DATADIR "/" PACKAGE "/pixmaps");
#endif
    if(P==NULL &&
       g_file_test("pixmaps",  G_FILE_TEST_IS_DIR))
      P=g_strdup("pixmaps");
    if(P) {      
      if( debug_mode ) 
	g_debug("pulling pixmaps from '%s'",P);
      add_pixmap_directory (P);
      g_free(P);
    } else g_warning("could not locate pixmaps");
  }

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  /* Create a new file selection widget */

  //HACK imageselection1_g =     GTK_FILE_SELECTION(create_imageselection1() );

  /* this will crash if some problems are encountered */
  fileselection1_for_image_num_g=-5;

    
  /* sp->resulting_width =  sp->resulting_width_sp = 768; */
/*   sp->resulting_height = sp->resulting_height_sp = 576; */
/*   sp->meshes_x=40; */
/*   sp->meshes_y=30; */
  //SIMPLER SETUP

#ifdef IS_PLYMORPH
  sp->resulting_width =  sp->resulting_width_sp = 512;
  sp->resulting_height = sp->resulting_height_sp = 512;
#else
  sp->resulting_width =  sp->resulting_width_sp = 300;
  sp->resulting_height = sp->resulting_height_sp = 400;
  sp->meshes_x=12;
  sp->meshes_y=9;
#endif
  
  /************************ main window ******************/
  // FIXME I am undecided
  // 1) the resulting image is in a  window, and there is the main window
  // 2) the resulting image is in detachable handlebox in  ' '     ' '
  // Actually we can switch from one to the other:
  //  we detach the content and we attach it in the other.
  // It looks complicated but the fact is, I would like
  // the possibility that the user may set with a preference 1) or 2)
 /*  if (0) { */
/*     // case 1) NOW DONT WORK */
/*     //we create the MAIN_WIN to hold the resulting image */
/*     create_and_show_image_win(MAIN_WIN);     */
/*     { */
/*       GtkWidget* hb= lookup_widget  (window_main , */
/* 				     "resultingimage_frame"), */
/* 	* vb=lookup_widget  (sp->im_widget[MAIN_WIN] ,  "vbox3"); */
/*       g_assert(hb);  */
/*       g_assert(vb); */
/*       gtk_container_remove(GTK_CONTAINER (sp->im_widget[MAIN_WIN]), */
/* 			   vb); */
/*       gtk_container_add (GTK_CONTAINER (hb), vb);    */
/*       gtk_widget_destroy(sp->im_widget[MAIN_WIN]); */
/*       sp->im_widget[MAIN_WIN]=vb; */
/*     } */
/*   } */
/*   else //case 2) */

  GtkWidget *window_main=NULL;

#ifdef GOOD_OLD
  window_main = create_window_main ();
  //now it needs to be set to MA_WINS+1 since it contains the resulting image
  gtk_widget_set_data_top(window_main,"imagenum",
			  GUINT_TO_POINTER(MAIN_WIN));
  sp->im_widget[MAIN_WIN]=window_main;
  init_image_win_data_and_set_all(MAIN_WIN, window_main,"gtkmorph");
  gtk_window_set_default_size(GTK_WINDOW(window_main),600,400);
  gtk_widget_show (window_main);
#else
  create_and_show_image_win(MAIN_WIN);
  window_main=sp->im_widget[MAIN_WIN];
#endif

#ifdef IS_PLYMORPH
  GtkWidget *window_navigation=create_navigation();
  gtk_widget_show(window_navigation);
#else
 
  // need to allocate feature colors!
  allocate_colors( window_main );

  create_mag_();

  feature_init();

  {
    int lp; 
    for(lp=0 ; lp <= 2;  lp ++) {
      if(!add_feature(NULL))
	break;
    }
  }

  /* fix things as prescribed by the current settings */
  gtkmorph_settings_callback(NULL,NULL);   
#endif
  
  /* show it */
  //sp->max_wins=0;
  //while (gtk_events_pending())
  //  gtk_main_iteration ();

  
  /******************************************* create images */    
  // this is honored in the following
  sp->max_wins=1;
  
   
  //setup_handlebox_factors();    

  movie_init();
#if HAVE_WAILI
  wavelet_init();
#endif
#ifndef IS_PLYMORPH
  fourier_init();
#endif

  if(argc<=1 || ( debug_mode && argc <= 2) )
  {
    int lp;
    for(lp=1 ; lp <= sp->max_wins;  lp ++)      create_and_show_image_win(lp);
  } 
  else {
    load_session(MAIN_WIN,argv[argc-1]);
  }
  gtk_main ();

  return 0;
}
