#include <testclasses.h>
#include <eventtestbox.h>
#include <string>
#include <iostream>

class TestForm : public VDKForm
{
 private:
     void mesg_handler(VDKObject*, const char*);
     VDKBox* hbox1;
     VDKBox* hbox2;
     VDKBox* hbox3;
//       VDKToggleButton* tbtn;
//       VDKToggleButtonTest* tbtntest;
//       VDKCheckButton* cbtn;
//       VDKCheckButtonTest* cbtntest;
     VDKSpinButton* spbtn;
     VDKSpinButtonTest* spbtntest;
     VDKCustomList* clist;
     VDKCustomListTest* clisttest;
     VDKCustomTree* ctree;
     VDKCustomTreeTest* ctreetest;
     VDKCombo* combo;
     VDKComboTest* combotest;
     VDKSlider* slider;
     VDKSliderTest* slidertest;
     /*
     VDKGrid* grid;
     VDKGridTest* gridtest;
     */
     VDKNotebook* notebook;
     VDKNotebookTest* notebooktest;
     EventTestBox* eventbox;

 public:
     TestForm(VDKApplication* app)
	  : VDKForm(app)
     {}
     ~TestForm()
     {
//  	  delete tbtntest;
//  	  delete cbtntest;
	  delete spbtntest;
	  delete clisttest;
	  delete ctreetest;
	  delete combotest;
	  delete slidertest;
     }
     void Setup();
};

class TestApp : public VDKApplication
{
public:
     TestApp(int* argc, char** argv)
	  : VDKApplication(argc, argv)
     {}
     ~TestApp(){};
     void Setup()
     {
	  MainForm=new TestForm(this);
	  MainForm->Setup();
	  MainForm->Show();
     }
};

void 
TestForm::Setup()
{
     SetTitle("VDK test for sigc++-extension");
     hbox1=new VDKBox(this, h_box);
     hbox2=new VDKBox(this, h_box);
     hbox3=new VDKBox(this, h_box);
     Add(hbox1);
     Add(hbox2);
     Add(hbox3);

//       tbtn=new VDKToggleButton(this);
//       tbtntest=new VDKToggleButtonTest(tbtn);
//       hbox1->Add(tbtn);
//       tbtntest->OnMesg.connect(slot(*this,
//  				   &TestForm::mesg_handler));
     
//       cbtn=new VDKCheckButton(this);
//       cbtntest=new VDKCheckButtonTest(cbtn);
//       hbox1->Add(cbtn);
//       cbtntest->OnMesg.connect(slot(*this,
//  				   &TestForm::mesg_handler));

     spbtn=new VDKSpinButton(this, 5, 0, 10, 1,0);
     spbtntest=new VDKSpinButtonTest(spbtn);
     hbox1->Add(spbtn);
     spbtntest->OnMesg.connect(slot(*this,
				    &TestForm::mesg_handler));

     notebook=new VDKNotebook(this);
     notebooktest=new VDKNotebookTest(notebook);
     hbox2->Add(notebook);
     notebooktest->OnMesg.connect(slot(*this,
				       &TestForm::mesg_handler));

     char* titles[4]={"1. word", "2. word", "3. word", "4. word"};
     clist=new VDKCustomList(this, 4, titles);
     clisttest=new VDKCustomListTest(clist);
     notebook->AddPage(clist,"VDKCustomList");
     clisttest->OnMesg.connect(slot(*this,
				    &TestForm::mesg_handler));

     char* titles2[1]={"VDKCustomTree"};
     ctree=new VDKCustomTree(this,1,titles2);
     ctreetest=new VDKCustomTreeTest(ctree);
     notebook->AddPage(ctree,"VDKCustomTree");
     ctreetest->OnMesg.connect(slot(*this,
				    &TestForm::mesg_handler));

     combo=new VDKCombo(this);
     combotest=new VDKComboTest(combo);
     hbox1->Add(combo);
     combotest->OnMesg.connect(slot(*this,
				    &TestForm::mesg_handler));
     
     slider=new VDKSlider(this, 5, 0, 10, 1);
     slidertest=new VDKSliderTest(slider);
     hbox1->Add(slider);
     slidertest->OnMesg.connect(slot(*this,
				     &TestForm::mesg_handler));

     /*
     grid=new VDKGrid(this,10,10,true);
     gridtest=new VDKGridTest(grid);
     VDKScrolled* gridcontainer_h=new VDKScrolled(this, h_box);
     notebook->AddPage(gridcontainer_h,"VDKGrid");
     gridcontainer_h->AddWithViewport(grid);
     gridtest->OnMesg.connect(slot(*this,
				   &TestForm::mesg_handler));
     */
     eventbox=new EventTestBox(this);
     Add(eventbox);
     eventbox->OnMesg.connect(slot(*this,
				   &TestForm::mesg_handler));
}

void
  TestForm::mesg_handler(VDKObject* obj, const char* mesg)
{
	std::cout << mesg ;
}

int main(int argc, char** argv)
{
     TestApp app(&argc, argv);
	std::cout << "VDKObject" << sizeof(VDKObject) << std::endl;
     app.Run();
     return 0;
}
