package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBProxy invokes the rds.DescribeDBProxy API synchronously
func (client *Client) DescribeDBProxy(request *DescribeDBProxyRequest) (response *DescribeDBProxyResponse, err error) {
	response = CreateDescribeDBProxyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBProxyWithChan invokes the rds.DescribeDBProxy API asynchronously
func (client *Client) DescribeDBProxyWithChan(request *DescribeDBProxyRequest) (<-chan *DescribeDBProxyResponse, <-chan error) {
	responseChan := make(chan *DescribeDBProxyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBProxy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBProxyWithCallback invokes the rds.DescribeDBProxy API asynchronously
func (client *Client) DescribeDBProxyWithCallback(request *DescribeDBProxyRequest, callback func(response *DescribeDBProxyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBProxyResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBProxy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBProxyRequest is the request struct for api DescribeDBProxy
type DescribeDBProxyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
}

// DescribeDBProxyResponse is the response struct for api DescribeDBProxy
type DescribeDBProxyResponse struct {
	*responses.BaseResponse
	RequestId                          string                    `json:"RequestId" xml:"RequestId"`
	DBProxyServiceStatus               string                    `json:"DBProxyServiceStatus" xml:"DBProxyServiceStatus"`
	DBProxyInstanceType                string                    `json:"DBProxyInstanceType" xml:"DBProxyInstanceType"`
	DBProxyInstanceNum                 int                       `json:"DBProxyInstanceNum" xml:"DBProxyInstanceNum"`
	DBProxyInstanceStatus              string                    `json:"DBProxyInstanceStatus" xml:"DBProxyInstanceStatus"`
	DBProxyInstanceCurrentMinorVersion string                    `json:"DBProxyInstanceCurrentMinorVersion" xml:"DBProxyInstanceCurrentMinorVersion"`
	DBProxyInstanceLatestMinorVersion  string                    `json:"DBProxyInstanceLatestMinorVersion" xml:"DBProxyInstanceLatestMinorVersion"`
	DBProxyInstanceName                string                    `json:"DBProxyInstanceName" xml:"DBProxyInstanceName"`
	DBProxyConnectStringItems          DBProxyConnectStringItems `json:"DBProxyConnectStringItems" xml:"DBProxyConnectStringItems"`
	DbProxyEndpointItems               DbProxyEndpointItems      `json:"DbProxyEndpointItems" xml:"DbProxyEndpointItems"`
}

// CreateDescribeDBProxyRequest creates a request to invoke DescribeDBProxy API
func CreateDescribeDBProxyRequest() (request *DescribeDBProxyRequest) {
	request = &DescribeDBProxyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeDBProxy", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBProxyResponse creates a response to parse from DescribeDBProxy response
func CreateDescribeDBProxyResponse() (response *DescribeDBProxyResponse) {
	response = &DescribeDBProxyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
