# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** system environment, resource control and configuration details

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/se_version.rb;hb=HEAD]

=end
module SiSU_Info_Version
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  require_relative 'se_info_env'                           # se_info_env.rb
  begin
    require 'singleton'
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
      error('singleton NOT FOUND (LoadError)')
  end
  class InfoVersion < SiSU_Info_Env::InfoEnv               # se_info_env.rb
    include Singleton
    begin
      require 'rbconfig'
      require 'yaml'
    rescue LoadError
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
        error('rbconfig or yaml NOT FOUND (LoadError)')
    end
    @@lib_path=nil
    def get_version
      version={}
      @pwd=ENV['PWD']
      lib_path=
        @@lib_path \
        ? @@lib_path
        : `echo $RUBYLIB`.split(':')
      @@lib_path ||=lib_path
      if File.exist?(SiSU_is.version_info_path?)
        version=YAML::load(File::open(SiSU_is.version_info_path?))
      end
      version[:install_method]=if SiSU_is.runtime_type? ==:gem_install
        spec = Gem::Specification.find_by_name("sisu")
        gem_root = spec.gem_dir
        (File.dirname(__FILE__.gsub(/\/lib\/sisu}/,'')) == gem_root) \
        ? ' (ruby gem install)' : ''
      else ''
      end
      @version=version
      def version_details_hash
        @version
      end
      def project
        version_details_hash[:project]
      end
      def date
        version_details_hash[:date]
      end
      def date_stamp
        version_details_hash[:date_stamp]
      end
      def version
        version_details_hash[:version]
      end
      def version_major
        @version_major=version_details_hash[:version].gsub(/([0-9]+)\.[0-9]+\.[0-9]+/,'\1')
      end
      def install_method
        version_details_hash[:install_method]
      end
      self
    end
    def rbversion
      %x{ruby -v}.strip
    end
  end
end
module SiSU_Info_About
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  begin
    require 'singleton'
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
      error('singleton NOT FOUND (LoadError)')
  end
  class InfoAbout
    def initialize(color='')
      @color=color
    end
    def sisu_version
      version=SiSU_Env::InfoVersion.instance.get_version
      rb_ver=SiSU_Env::InfoVersion.instance.rbversion
      if version.version
        opt_cmd=if defined? @color.cmd \
        and @color.cmd =~/[ck]/
          @color.cmd
        else '-v'
        end
        SiSU_Screen::Ansi.new(
          opt_cmd,
          version.project,
          version.version,
          version.date_stamp,
          version.date,
          version.install_method,
          rb_ver
        ).version
      else puts 'SiSU (version information not available)'
      end
    end
    def sisu_about
      puts <<-WOK
     sisu: documents; markup, structuring, publishing in multiple standard formats, & search
     most (not all) useful commands (are made in a directory containing a sisu markup file &) take the form:
       sisu [action(s)] [filename(s)]
     where filename refers to a valid sisu marked up file, e.g.:
       cd /usr/share/doc/sisu/markup-samples/sisu_manual
       sisu --html --verbose sisu_commands.sst
       sisu --txt --html --epub --odt --pdf --sqlite --manpage --texinfo --concordance --qrcode --verbose sisu.ssm
       cd -
     See output produced, or see man pages: man sisu
     <http://www.sisudoc.org/> <http://www.jus.uio.no/sisu/>
        WOK
    end
  end
end
__END__
