% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/command.R
\name{Rscript_call}
\alias{Rscript_call}
\title{Call a function in a new R session via \code{Rscript()}}
\usage{
Rscript_call(
  fun,
  args = list(),
  options = NULL,
  ...,
  wait = TRUE,
  fail = sprintf("Failed to run '\%s' in a new R session.", deparse(substitute(fun))[1])
)
}
\arguments{
\item{fun}{A function, or a character string that can be parsed and evaluated
to a function.}

\item{args}{A list of argument values.}

\item{options}{A character vector of options to passed to
\code{\link[=Rscript]{Rscript()}}, e.g., \code{"--vanilla"}.}

\item{..., wait}{Arguments to be passed to \code{\link[=system2]{system2()}}.}

\item{fail}{The desired error message when an error occurred in calling the
function.}
}
\value{
The returned value of the function in the new R session.
}
\description{
Save the argument values of a function in a temporary RDS file, open a new R
session via \code{\link[=Rscript]{Rscript()}}, read the argument values, call the
function, and read the returned value back to the current R session.
}
\examples{
factorial(10)
# should return the same value
xfun::Rscript_call("factorial", list(10))

# the first argument can be either a character string or a function
xfun::Rscript_call(factorial, list(10))

# Run Rscript starting a vanilla R session
xfun::Rscript_call(factorial, list(10), options = c("--vanilla"))
}
