% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{nexml-class}
\alias{nexml-class}
\alias{nexml}
\title{Class representing a NeXML document}
\description{
The \code{nexml} class represents a NeXML document, and is the top of the
class hierarchy defined in this package, corresponding to the root node
of the corresponding XML document.
}
\details{
Normally objects of this type are created by the package as a result of
reading a NeXML file, or of converting from another type, such as
\code{ape::phylo}. Also, interacting directly with the slots of the class is
normally not necessary. Instead, use the \code{get_XXX()} and \code{add_XXX()}
functions in the API.
}
\section{Slots}{

\describe{
\item{\code{trees}}{list, corresponding to the list of \verb{<trees/>} elements in
NeXML. Elements will be of class \code{trees}.}

\item{\code{characters}}{list, corresponding to the list of \verb{<characters/>}
elements in NeXML. Elements will be of class \code{characters}.}

\item{\code{otus}}{list, corresponding to the list of \verb{<otus/>} elements in NeXML.
Elements will be of class \code{otus}.}

\item{\code{about}}{inherited, see \link[=Annotated-class]{Annotated}}

\item{\code{meta}}{inherited, see \link[=Annotated-class]{Annotated}}

\item{\code{xsi:type}}{for internal use}

\item{\code{version}}{NeXML schema version, do not change}

\item{\code{generator}}{name of software generating the XML}

\item{\code{xsi:schemaLocation}}{for internal use, do not change}

\item{\code{namespaces}}{named character vector giving the XML namespaces}
}}

\examples{
nex <- nexml() # a nexml object with no further content
nex <- new("nexml") # accomplishes the same thing
nex@generator
length(nex@trees)

data(bird.orders)
nex <- as(bird.orders, "nexml")
summary(nex)
length(nex@trees)
}
\seealso{
\code{\link[=read.nexml]{read.nexml()}}
}
