% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_helpers.R
\name{select_helpers}
\alias{select_helpers}
\alias{starts_with}
\alias{ends_with}
\alias{contains}
\alias{matches}
\alias{num_range}
\alias{all_of}
\alias{any_of}
\alias{everything}
\alias{last_col}
\title{Select Helpers}
\usage{
starts_with(match, ignore.case = TRUE, vars = peek_vars())

ends_with(match, ignore.case = TRUE, vars = peek_vars())

contains(match, ignore.case = TRUE, vars = peek_vars())

matches(match, ignore.case = TRUE, perl = FALSE, vars = peek_vars())

num_range(prefix, range, width = NULL, vars = peek_vars())

all_of(x, vars = peek_vars())

any_of(x, vars = peek_vars())

everything(vars = peek_vars())

last_col(offset = 0L, vars = peek_vars())
}
\arguments{
\item{match}{\code{character(n)}. If length > 1, the union of the matches is taken.}

\item{ignore.case}{\code{logical(1)}. If \code{TRUE}, the default, ignores case when matching names.}

\item{vars}{\code{character(n)}. A character vector of variable names. When called from inside selecting functions such as
\code{select()}, these are automatically set to the names of the table.}

\item{perl}{\code{logical(1)}. Should Perl-compatible regexps be used?}

\item{prefix}{A prefix which starts the numeric range.}

\item{range}{\code{integer(n)}. A sequence of integers, e.g. \code{1:5}.}

\item{width}{\code{numeric(1)}. Optionally, the "width" of the numeric range. For example, a range of 2 gives "01", a
range of three "001", etc.}

\item{x}{\code{character(n)}. A vector of column names.}

\item{offset}{\code{integer(1)}. Select the \code{n}th variable from the end of the \code{data.frame}.}
}
\value{
An integer vector giving the position of the matched variables.
}
\description{
These functions allow you to select variables based on their names.
\itemize{
\item \code{starts_with()}: Starts with a prefix.
\item \code{ends_with()}: Ends with a prefix.
\item \code{contains()}: Contains a literal string.
\item \code{matches()}: Matches a regular expression.
\item \code{all_of()}: Matches variable names in a character vector. All names must be present, otherwise an error is thrown.
\item \code{any_of()}: The same as \code{all_of()} except it doesn't throw an error.
\item \code{everything()}: Matches all variables.
\item \code{last_col()}: Select the last variable, possibly with an offset.
}
}
\examples{
mtcars \%>\% select(starts_with("c"))
mtcars \%>\% select(starts_with(c("c", "h")))
mtcars \%>\% select(ends_with("b"))
mtcars \%>\% relocate(contains("a"), .before = mpg)
iris \%>\% select(matches(".t."))
mtcars \%>\% select(last_col())

# `all_of()` selects the variables in a character vector:
iris \%>\% select(all_of(c("Petal.Length", "Petal.Width")))
# `all_of()` is strict and will throw an error if the column name isn't found
try({iris \%>\% select(all_of(c("Species", "Genres")))})
# However `any_of()` allows missing variables
iris \%>\% select(any_of(c("Species", "Genres")))

}
\seealso{
\code{\link[=select]{select()}}, \code{\link[=relocate]{relocate()}}, \code{\link[=where]{where()}}, \code{\link[=group_cols]{group_cols()}}
}
