% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_build.R
\name{plotly_build}
\alias{plotly_build}
\title{'Build' (i.e., evaluate) a plotly object}
\usage{
plotly_build(p, registerFrames = TRUE)
}
\arguments{
\item{p}{a ggplot object, or a plotly object, or a list.}

\item{registerFrames}{should a frame trace attribute be interpreted as frames in an animation?}
}
\description{
This generic function creates the list object sent to plotly.js
for rendering. Using this function can be useful for overriding defaults
provided by \code{ggplotly}/\code{plot_ly} or for debugging rendering
errors.
}
\examples{

p <- plot_ly(economics, x = ~date, y = ~pce)
# the unevaluated plotly object
str(p)
# the evaluated data
str(plotly_build(p)$x$data)

}
