% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/high_level_UI.R
\name{args_regularity_evaluation}
\alias{args_regularity_evaluation}
\title{Evaluate if the arguments are regular for hyperslab use}
\usage{
args_regularity_evaluation(args, ds_dims, envir, post_read = TRUE)
}
\arguments{
\item{args}{The arguments input; if it was empty, then set to NULL}

\item{ds_dims}{The dimensions of the input dataset}

\item{envir}{The environment in which to evaluate the arguments}

\item{post_read}{Should the reshuffle be computed for post-read (then \code{TRUE}) or pre-write (then \code{FALSE})}
}
\value{
A list with 2 parts; Evaluated arguments, regularity report and reshuffle indicators. Will be returned as a list
with components \code{args_in}, \code{args_point}, \code{is_hyperslab}, \code{hyperslab},
\code{needs_reshuffle}, \code{reshuffle}, \code{result_dims_pre_shuffle}, \code{result_dims_post_shuffle}, \code{max_dims}
}
\description{
Evaluate if the arguments are regular for hyperslab use
}
\details{
For each argument check if it can be used as a hyperslab, potentially after sorting and making unique.
}
\author{
Holger Hoefling
}
\keyword{internal}
