% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gprofiler2.R
\name{get_version_info}
\alias{get_version_info}
\title{Get version info of g:Profiler data sources}
\usage{
get_version_info(organism = "hsapiens")
}
\arguments{
\item{organism}{organism name. Organism names are constructed by concatenating the first letter of the name and the family name. Example: human - 'hsapiens', mouse - 'mmusculus'.}
}
\value{
A named nested list that includes the versions for all the data sources (GO, KEGG, Reactome, WP, etc) at the time of the data extraction for the given organism.
The versions correspond to the g:Profiler version embedded in the base_url which is also returned by this function under the name 'gprofiler_version'.
}
\description{
Get version info of g:Profiler data sources
}
\examples{
\dontrun{version_info <- get_version_info(organism = "hsapiens")}

}
\author{
Liis Kolberg <liis.kolberg@ut.ee>
}
