% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduced.dim.matrix.R
\name{reduced.dim.matrix}
\alias{reduced.dim.matrix}
\alias{reduced.dim.matrix-class}
\alias{[.reduced.dim.matrix}
\alias{cbind.reduced.dim.matrix}
\alias{rbind.reduced.dim.matrix}
\title{The reduced.dim.matrix class}
\description{
A matrix class that retains its attributes upon being subsetted or combined.
This is useful for storing metadata about a dimensionality reduction result alongside the matrix,
and for ensuring that the metadata persists when the matrix is stored inside \code{\link{reducedDims}}.
}
\section{Constructor}{

\code{reduced.dim.matrix(x, ...)} will return a reduced.dim.matrix object, given a matrix input \code{x}.
Arguments in \code{...} should be named and are stored as custom attributes in the output.
Any arguments named \code{dim} or \code{dimnames} are ignored.
}

\section{Subsetting}{

\code{x[i, j, ..., drop=FALSE]} will subset a reduced.dim.matrix \code{x} in the same manner as a base matrix.
The only difference is that a reduced.dim.matrix will be returned, retaining any custom attributes in \code{x}.
Note that no custom attributes are retained if the return value is a vector with \code{drop=TRUE}.
}

\section{Combining}{

\code{rbind(...)} will combine multiple reduced.dim.matrix inputs in \code{...} by row, 
while \code{cbind(...)} will combine those inputs by column.

If the custom attributes are the same across all objects \code{...},
a reduced.dim.matrix is returned containing all combined rows/columns as well as the custom attributes.

If the custom attributes are different, a warning is issued.
A matrix is returned containing all combined rows/columns; no custom attributes are retained.
}

\examples{
# Typical PC result, with metadata stored in the attributes:
pc <- matrix(runif(500), ncol=5)
attr(pc, "sdev") <- 1:100
attr(pc, "rotation") <- matrix(rnorm(20), ncol=5)

# Disappears upon subsetting and combining!
attributes(pc[1:10,])
attributes(rbind(pc, pc))

# Transformed into a reduced.dim.matrix:
rd.pc <- reduced.dim.matrix(pc)

attributes(rd.pc[1:10,])
attributes(rbind(rd.pc, rd.pc))

}
\seealso{
\code{\link{reducedDims}}, to store these objects in a \linkS4class{SingleCellExperiment}.
}
\author{
Aaron Lun
}
