% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoupleR-pre.R
\name{filt_minsize}
\alias{filt_minsize}
\title{Filter sources with minsize targets}
\usage{
filt_minsize(mat_f_names, network, minsize = 5)
}
\arguments{
\item{mat_f_names}{Feature names of mat.}

\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{minsize}{Integer indicating the minimum number of targets per source.}
}
\value{
Filtered network.
}
\description{
Filter sources of a net with less than minsize targets
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")
mat <- readRDS(file.path(inputs_dir, "mat.rds"))
net <- readRDS(file.path(inputs_dir, "net.rds"))
net <- rename_net(net, source, target, mor)
filt_minsize(rownames(mat), net, minsize = 4)
}
